/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.BadRequestWebException;
import com.atlassian.jira.rest.v2.issue.IssueInputParametersAssembler;
import com.atlassian.jira.rest.v2.issue.IssueUpdateBean;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import javax.ws.rs.core.Response;

public class UpdateIssueResource {
    private final IssueInputParametersAssembler issueInputParametersAssembler;
    private final IssueService issueService;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public UpdateIssueResource(IssueInputParametersAssembler issueInputParametersAssembler, IssueService issueService, JiraAuthenticationContext jiraAuthenticationContext) {
        this.issueInputParametersAssembler = issueInputParametersAssembler;
        this.issueService = issueService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public Response editIssue(Issue issue, IssueUpdateBean updateRequest) {
        IssueInputParametersAssembler.Result result = this.issueInputParametersAssembler.makeUpdateAssembler(updateRequest, issue);
        if (result.getErrors().hasAnyErrors()) {
            throw new BadRequestWebException(ErrorCollection.of(result.getErrors()));
        }
        IssueInputParameters inputParameters = result.getParameters();
        User user = this.jiraAuthenticationContext.getLoggedInUser();
        IssueService.UpdateValidationResult validation = this.issueService.validateUpdate(user, issue.getId(), inputParameters);
        if (!validation.isValid()) {
            throw new BadRequestWebException(ErrorCollection.of(validation.getErrorCollection()));
        }
        IssueService.IssueResult issueResult = this.issueService.update(user, validation);
        if (!issueResult.isValid()) {
            throw new BadRequestWebException(ErrorCollection.of(issueResult.getErrorCollection()));
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response transitionIssue(Issue issue, IssueUpdateBean issueUpdateBean) {
        IssueInputParametersAssembler.Result result = this.issueInputParametersAssembler.makeTransitionAssember(issueUpdateBean, issue);
        if (result.getErrors().hasAnyErrors()) {
            throw new BadRequestWebException(ErrorCollection.of(result.getErrors()));
        }
        IssueInputParameters inputParameters = result.getParameters();
        User user = this.jiraAuthenticationContext.getLoggedInUser();
        IssueService.TransitionValidationResult validationResult = this.issueService.validateTransition(user, issue.getId(), Integer.valueOf(issueUpdateBean.getTransition().getId()).intValue(), inputParameters);
        if (!validationResult.isValid()) {
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(validationResult.getErrorCollection()));
        }
        this.issueService.transition(user, validationResult);
        return Response.noContent().build();
    }
}

