/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.WorkflowIssueOperationImpl;
import com.atlassian.jira.rest.v2.issue.AbstractMetaFieldBeanBuilder;
import com.atlassian.jira.rest.v2.issue.FieldMetaBean;
import com.atlassian.jira.rest.v2.issue.context.ContextUriInfo;
import com.atlassian.jira.rest.v2.issue.version.VersionBeanFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.HashMap;
import java.util.Map;

public class TransitionMetaFieldBeanBuilder
extends AbstractMetaFieldBeanBuilder {
    private final ActionDescriptor action;
    private FieldScreenRenderer fieldScreenRenderer;

    public TransitionMetaFieldBeanBuilder(FieldScreenRendererFactory fieldScreenRendererFactory, FieldLayoutManager fieldLayoutManager, ActionDescriptor action, Issue issue, User user, VersionBeanFactory versionBeanFactory, VelocityRequestContextFactory velocityRequestContextFactory, ContextUriInfo contextUriInfo, JiraBaseUrls baseUrls) {
        super(fieldLayoutManager, issue.getProjectObject(), issue, issue.getIssueTypeObject(), user, versionBeanFactory, velocityRequestContextFactory, contextUriInfo, baseUrls, null);
        this.action = action;
        this.fieldScreenRenderer = fieldScreenRendererFactory.getFieldScreenRenderer(user, issue, action);
    }

    @Override
    public OperationContext getOperationContext() {
        return new OperationContext(){

            public Map getFieldValuesHolder() {
                return null;
            }

            public IssueOperation getIssueOperation() {
                return new WorkflowIssueOperationImpl(TransitionMetaFieldBeanBuilder.this.action);
            }
        };
    }

    @Override
    public Map<String, FieldMetaBean> build() {
        HashMap<String, FieldMetaBean> fields = new HashMap<String, FieldMetaBean>();
        for (FieldScreenRenderTab fieldScreenRenderTab : this.fieldScreenRenderer.getFieldScreenRenderTabs()) {
            for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItemsForProcessing()) {
                if (!fieldScreenRenderLayoutItem.isShow(this.issue)) continue;
                OrderableField field = fieldScreenRenderLayoutItem.getOrderableField();
                FieldLayoutItem fieldLayoutItem = fieldScreenRenderLayoutItem.getFieldLayoutItem();
                FieldMetaBean fieldMetaBean = "resolution".equals(field.getId()) ? this.getFieldMetaBean(true, field) : this.getFieldMetaBean(fieldLayoutItem.isRequired(), field);
                fields.put(field.getId(), fieldMetaBean);
            }
        }
        return fields;
    }

    @Override
    public boolean hasPermissionToPerformOperation() {
        return true;
    }

    @Override
    FieldScreenRenderer getFieldScreenRenderer(Issue issue) {
        throw new RuntimeException("Should never call this method!");
    }
}

