/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.StatusJsonBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.rest.v2.issue.TransitionBean;
import com.atlassian.jira.rest.v2.issue.TransitionMetaFieldBeanBuilder;
import com.atlassian.jira.rest.v2.issue.context.ContextUriInfo;
import com.atlassian.jira.rest.v2.issue.version.VersionBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;

public class TransitionMetaBeanBuilder {
    private static final int AUTOMATIC_LOOP_BACK_STEP_ID = -1;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final JiraAuthenticationContext authContext;
    private final FieldLayoutManager fieldLayoutManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final ContextUriInfo contextUriInfo;
    private final VersionBeanFactory versionBeanFactory;
    private final JiraBaseUrls baseUrls;
    private final WorkflowManager workflowManager;
    private final StatusManager statusManager;
    private ActionDescriptor action;
    private Issue issue;

    public TransitionMetaBeanBuilder(FieldScreenRendererFactory fieldScreenRendererFactory, JiraAuthenticationContext authContext, FieldLayoutManager fieldLayoutManager, VelocityRequestContextFactory velocityRequestContextFactory, ContextUriInfo contextUriInfo, VersionBeanFactory versionBeanFactory, JiraBaseUrls baseUrls, WorkflowManager workflowManager, StatusManager statusManager) {
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.authContext = authContext;
        this.fieldLayoutManager = fieldLayoutManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.contextUriInfo = contextUriInfo;
        this.versionBeanFactory = versionBeanFactory;
        this.baseUrls = baseUrls;
        this.workflowManager = workflowManager;
        this.statusManager = statusManager;
    }

    public TransitionMetaBeanBuilder issue(Issue issue) {
        this.issue = issue;
        return this;
    }

    public TransitionMetaBeanBuilder action(ActionDescriptor action) {
        this.action = action;
        return this;
    }

    public TransitionBean build() {
        Status destinationStatus = this.getStatusFromStep(this.issue, this.action.getUnconditionalResult().getStep());
        TransitionMetaFieldBeanBuilder fieldBuilder = new TransitionMetaFieldBeanBuilder(this.fieldScreenRendererFactory, this.fieldLayoutManager, this.action, this.issue, this.authContext.getLoggedInUser(), this.versionBeanFactory, this.velocityRequestContextFactory, this.contextUriInfo, this.baseUrls);
        return new TransitionBean(String.valueOf(this.action.getId()), WorkflowUtil.getWorkflowTransitionDisplayName((ActionDescriptor)this.action), fieldBuilder, StatusJsonBean.bean((Status)destinationStatus, (JiraBaseUrls)this.baseUrls));
    }

    private Status getStatusFromStep(Issue issue, int stepId) {
        WorkflowDescriptor workflowDescriptor = this.workflowManager.getWorkflow(issue).getDescriptor();
        String statusId = -1 == stepId ? issue.getStatusObject().getId() : (String)workflowDescriptor.getStep(stepId).getMetaAttributes().get("jira.status.id");
        return this.statusManager.getStatus(statusId);
    }
}

