/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.config.ConstantsService;
import com.atlassian.jira.issue.fields.rest.json.beans.StatusJsonBean;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.util.StatusHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="status")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class StatusResource {
    private ConstantsService constantsService;
    private JiraAuthenticationContext authContext;
    private StatusHelper statusHelper;

    private StatusResource() {
    }

    public StatusResource(JiraAuthenticationContext authContext, ConstantsService constantsService, StatusHelper statusHelper) {
        this.authContext = authContext;
        this.constantsService = constantsService;
        this.statusHelper = statusHelper;
    }

    @GET
    public Response getStatuses(@Context Request request, @Context UriInfo uriInfo) {
        ServiceOutcome outcome = this.constantsService.getAllStatuses(this.authContext.getLoggedInUser());
        if (!outcome.isValid()) {
            throw new NotFoundWebException(ErrorCollection.of(outcome.getErrorCollection()));
        }
        ArrayList<StatusJsonBean> beans = new ArrayList<StatusJsonBean>();
        for (Status status : (Collection)outcome.getReturnedValue()) {
            StatusJsonBean statusBean = this.statusHelper.createStatusBean(status, uriInfo, StatusResource.class);
            beans.add(statusBean);
        }
        return Response.ok(beans).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{idOrName}")
    public Response getStatus(@PathParam(value="idOrName") String idOrName, @Context Request request, @Context UriInfo uriInfo) {
        ServiceOutcome statusOutcome = this.constantsService.getStatusById(this.authContext.getLoggedInUser(), idOrName);
        if (!statusOutcome.isValid() && !(statusOutcome = this.constantsService.getStatusByTranslatedName(this.authContext.getLoggedInUser(), idOrName)).isValid()) {
            throw new NotFoundWebException(ErrorCollection.of(statusOutcome.getErrorCollection()));
        }
        return Response.ok((Object)this.statusHelper.createStatusBean((Status)statusOutcome.getReturnedValue(), uriInfo, StatusResource.class)).cacheControl(CacheControl.never()).build();
    }
}

