/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.rest.v2.issue.IssueResource;
import com.atlassian.jira.rest.v2.issue.RemoteIssueLinkBean;
import com.atlassian.jira.rest.v2.issue.context.ContextUriInfo;
import java.net.URI;

public class RemoteIssueLinkBeanBuilder {
    private final ContextUriInfo contextUriInfo;
    private final IssueManager issueManager;
    private final RemoteIssueLink remoteIssueLink;

    public RemoteIssueLinkBeanBuilder(ContextUriInfo contextUriInfo, IssueManager issueManager, RemoteIssueLink remoteIssueLink) {
        this.contextUriInfo = contextUriInfo;
        this.issueManager = issueManager;
        this.remoteIssueLink = remoteIssueLink;
    }

    public RemoteIssueLinkBean build() {
        URI self = this.createSelfLink(this.remoteIssueLink);
        return new RemoteIssueLinkBean(this.remoteIssueLink.getId(), self, this.remoteIssueLink.getGlobalId(), this.remoteIssueLink.getApplicationType(), this.remoteIssueLink.getApplicationName(), this.remoteIssueLink.getRelationship(), this.remoteIssueLink.getUrl(), this.remoteIssueLink.getTitle(), this.remoteIssueLink.getSummary(), this.remoteIssueLink.getIconUrl(), this.remoteIssueLink.getIconTitle(), this.remoteIssueLink.isResolved(), this.remoteIssueLink.getStatusIconUrl(), this.remoteIssueLink.getStatusIconTitle(), this.remoteIssueLink.getStatusIconLink());
    }

    private URI createSelfLink(RemoteIssueLink remoteIssueLink) {
        MutableIssue issue = this.issueManager.getIssueObject(remoteIssueLink.getIssueId());
        return RemoteIssueLinkBeanBuilder.createSelfLink(remoteIssueLink, (Issue)issue, this.contextUriInfo);
    }

    static URI createSelfLink(RemoteIssueLink remoteIssueLink, Issue issue, ContextUriInfo contextUriInfo) {
        return contextUriInfo.getBaseUriBuilder().path(IssueResource.class).path(issue.getKey()).path("remotelink").path(remoteIssueLink.getId().toString()).build(new Object[0]);
    }
}

