/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.fugue.Either;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarPickerHelper;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.project.component.ProjectComponentService;
import com.atlassian.jira.bc.project.version.VersionService;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.ProjectJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.StatusJsonBean;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.api.issue.IssueTypeWithStatusJsonBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.util.AttachmentHelper;
import com.atlassian.jira.rest.util.StatusHelper;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.rest.v2.issue.AvatarBean;
import com.atlassian.jira.rest.v2.issue.AvatarCroppingBean;
import com.atlassian.jira.rest.v2.issue.AvatarResourceHelper;
import com.atlassian.jira.rest.v2.issue.IssueTypeResource;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.issue.ResourceUriBuilder;
import com.atlassian.jira.rest.v2.issue.StatusResource;
import com.atlassian.jira.rest.v2.issue.component.ComponentBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectBeanFactory;
import com.atlassian.jira.rest.v2.issue.project.ProjectFinder;
import com.atlassian.jira.rest.v2.issue.version.VersionBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.plugins.rest.common.multipart.FilePart;
import com.atlassian.plugins.rest.common.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.XsrfCheckFailedException;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;

@Path(value="project")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ProjectResource {
    private ProjectService projectService;
    private UserManager userManager;
    private JiraAuthenticationContext authContext;
    private UriInfo uriInfo;
    private ProjectManager projectManager;
    private AvatarResourceHelper avatarResourceHelper;
    private VersionService versionService;
    private ProjectComponentService projectComponentService;
    private ProjectBeanFactory projectBeanFactory;
    private VersionBeanFactory versionBeanFactory;
    private PermissionManager permissionManager;
    private AvatarService avatarService;
    private JiraBaseUrls jiraBaseUrls;
    private WorkflowManager workflowManager;
    private IssueTypeSchemeManager issueTypeSchemeManager;
    private ResourceUriBuilder uriBuilder;
    private StatusHelper statusHelper;
    private ProjectFinder projectFinder;
    private XsrfInvocationChecker xsrfChecker;

    private ProjectResource() {
    }

    public ProjectResource(ProjectService projectService, JiraAuthenticationContext authContext, UriInfo uriInfo, VersionService versionService, ProjectComponentService projectComponentService, AvatarService avatarService, UserManager userManager, ProjectBeanFactory projectBeanFactory, VersionBeanFactory versionBeanFactory, PermissionManager permissionManager, ProjectManager projectManager, AvatarManager avatarManager, AvatarPickerHelper avatarPickerHelper, AttachmentHelper attachmentHelper, JiraBaseUrls jiraBaseUrls, WorkflowManager workflowManager, IssueTypeSchemeManager issueTypeSchemeManager, ResourceUriBuilder uriBuilder, StatusHelper statusHelper, ProjectFinder projectFinder, XsrfInvocationChecker xsrfChecker) {
        this.workflowManager = workflowManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.uriBuilder = uriBuilder;
        this.statusHelper = statusHelper;
        this.projectFinder = projectFinder;
        this.avatarResourceHelper = new AvatarResourceHelper(authContext, avatarManager, avatarPickerHelper, attachmentHelper);
        this.permissionManager = permissionManager;
        this.avatarService = avatarService;
        this.projectService = projectService;
        this.authContext = authContext;
        this.versionService = versionService;
        this.projectComponentService = projectComponentService;
        this.userManager = userManager;
        this.projectBeanFactory = projectBeanFactory;
        this.versionBeanFactory = versionBeanFactory;
        this.uriInfo = uriInfo;
        this.projectManager = projectManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.xsrfChecker = xsrfChecker;
    }

    @GET
    @Path(value="{projectIdOrKey}")
    public Response getProject(@PathParam(value="projectIdOrKey") String projectIdOrKey, final @QueryParam(value="expand") String expand) {
        return (Response)this.getProjectForView(projectIdOrKey).left().on((Function)new Function<Project, Response>(){

            public Response apply(Project project) {
                return Response.ok((Object)ProjectResource.this.projectBeanFactory.fullProject(project, StringUtils.defaultString((String)expand))).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
            }
        });
    }

    @GET
    @Path(value="{projectIdOrKey}/versions")
    public Response getProjectVersions(@PathParam(value="projectIdOrKey") String projectIdOrKey, final @QueryParam(value="expand") String expand) {
        return (Response)this.getProjectForView(projectIdOrKey).left().on((Function)new Function<Project, Response>(){

            public Response apply(Project project) {
                VersionService.VersionsResult versionResult = ProjectResource.this.versionService.getVersionsByProject(ProjectResource.this.authContext.getLoggedInUser(), project);
                if (!versionResult.isValid()) {
                    throw new NotFoundWebException(ErrorCollection.of(versionResult.getErrorCollection()));
                }
                boolean expandOps = expand != null && expand.contains("operations");
                return Response.ok(ProjectResource.this.versionBeanFactory.createVersionBeans(versionResult.getVersions(), expandOps)).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
            }
        });
    }

    @GET
    @Path(value="{projectIdOrKey}/components")
    public Response getProjectComponents(@PathParam(value="projectIdOrKey") String projectIdOrKey) {
        return (Response)this.getProjectForView(projectIdOrKey).left().on((Function)new Function<Project, Response>(){

            public Response apply(Project project) {
                SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                Collection projectComponents = ProjectResource.this.projectComponentService.findAllForProject((com.atlassian.jira.util.ErrorCollection)errorCollection, project.getId());
                if (errorCollection.hasAnyErrors()) {
                    throw new NotFoundWebException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
                }
                Long assigneeType = project.getAssigneeType();
                long safeAssigneeType = assigneeType == null ? 2L : assigneeType;
                return Response.ok(ComponentBean.asFullBeans(projectComponents, ProjectResource.this.jiraBaseUrls, project.getLeadUserName(), safeAssigneeType, ProjectResource.this.userManager, ProjectResource.this.avatarService, ProjectResource.this.permissionManager, ProjectResource.this.projectManager)).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
            }
        });
    }

    @GET
    public Response getAllProjects() {
        ServiceOutcome outcome = this.projectService.getAllProjectsForAction(this.authContext.getUser(), ProjectAction.VIEW_PROJECT);
        if (outcome.getErrorCollection().hasAnyErrors()) {
            ErrorCollection errors = ErrorCollection.of(outcome.getErrorCollection());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errors).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
        }
        ArrayList<ProjectJsonBean> beans = new ArrayList<ProjectJsonBean>();
        for (Project project : (List)outcome.getReturnedValue()) {
            ProjectJsonBean projectBean = ProjectJsonBean.shortBean((Project)project, (JiraBaseUrls)this.jiraBaseUrls);
            beans.add(projectBean);
        }
        return Response.ok(beans).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
    }

    @GET
    @Path(value="{projectIdOrKey}/avatars")
    public Response getAllAvatars(@PathParam(value="projectIdOrKey") String projectIdOrKey) {
        return (Response)this.getProjectForView(projectIdOrKey).left().on((Function)new Function<Project, Response>(){

            public Response apply(Project project) {
                Avatar selectedAvatar = project.getAvatar();
                Long selectedAvatarId = selectedAvatar.getId();
                return ProjectResource.this.avatarResourceHelper.getAllAvatars(Avatar.Type.PROJECT, project.getId().toString(), selectedAvatarId);
            }
        });
    }

    @POST
    @Path(value="{projectIdOrKey}/avatar")
    public Response createAvatarFromTemporary(@PathParam(value="projectIdOrKey") String projectIdOrKey, final AvatarCroppingBean croppingInstructions) {
        return (Response)this.getProjectForEdit(projectIdOrKey).left().on((Function)new Function<Project, Response>(){

            public Response apply(Project project) {
                return ProjectResource.this.avatarResourceHelper.createAvatarFromTemporary(Avatar.Type.PROJECT, project.getId().toString(), croppingInstructions);
            }
        });
    }

    @PUT
    @Path(value="{projectIdOrKey}/avatar")
    public Response updateProjectAvatar(@PathParam(value="projectIdOrKey") String projectIdOrKey, final AvatarBean avatarBean) {
        return (Response)this.getProjectForEdit(projectIdOrKey).left().on((Function)new Function<Project, Response>(){

            public Response apply(Project project) {
                Long avatarId;
                String id = avatarBean.getId();
                try {
                    avatarId = id == null ? null : Long.valueOf(id);
                }
                catch (NumberFormatException e) {
                    avatarId = null;
                }
                ProjectService.UpdateProjectValidationResult updateProjectValidationResult = ProjectResource.this.projectService.validateUpdateProject(ProjectResource.this.authContext.getLoggedInUser(), project.getName(), project.getKey(), project.getDescription(), project.getLeadUserName(), project.getUrl(), project.getAssigneeType(), avatarId);
                if (!updateProjectValidationResult.isValid()) {
                    ProjectResource.this.throwWebException(updateProjectValidationResult.getErrorCollection());
                }
                ProjectResource.this.projectService.updateProject(updateProjectValidationResult);
                return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
            }
        });
    }

    @POST
    @Consumes(value={"*/*"})
    @Path(value="{projectIdOrKey}/avatar/temporary")
    public Response storeTemporaryAvatar(@PathParam(value="projectIdOrKey") String projectIdOrKey, final @QueryParam(value="filename") String filename, final @QueryParam(value="size") Long size, final @Context HttpServletRequest request) {
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(ExecutingHttpRequest.get());
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            throw new XsrfCheckFailedException();
        }
        return (Response)this.getProjectForEdit(projectIdOrKey).left().on((Function)new Function<Project, Response>(){

            public Response apply(Project project) {
                return ProjectResource.this.avatarResourceHelper.storeTemporaryAvatar(Avatar.Type.PROJECT, project.getId().toString(), filename, size, request);
            }
        });
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="{projectIdOrKey}/avatar/temporary")
    @Produces(value={"text/html"})
    public Response storeTemporaryAvatarUsingMultiPart(@PathParam(value="projectIdOrKey") String projectIdOrKey, final @MultipartFormParam(value="avatar") FilePart filePart, final @Context HttpServletRequest request) {
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(ExecutingHttpRequest.get());
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            throw new XsrfCheckFailedException();
        }
        return (Response)this.getProjectForEdit(projectIdOrKey).left().on((Function)new Function<Project, Response>(){

            public Response apply(Project project) {
                return ProjectResource.this.avatarResourceHelper.storeTemporaryAvatarUsingMultiPart(Avatar.Type.PROJECT, project.getId().toString(), filePart, request);
            }
        });
    }

    @DELETE
    @Path(value="{projectIdOrKey}/avatar/{id}")
    public Response deleteAvatar(@PathParam(value="projectIdOrKey") String projectIdOrKey, final @PathParam(value="id") Long id) {
        return (Response)this.getProjectForEdit(projectIdOrKey).left().on((Function)new Function<Project, Response>(){

            public Response apply(Project project) {
                return ProjectResource.this.avatarResourceHelper.deleteAvatar(id);
            }
        });
    }

    @GET
    @Path(value="{projectIdOrKey}/statuses")
    public Response getAllStatuses(@PathParam(value="projectIdOrKey") String projectIdOrKey) {
        return (Response)this.getEitherProjectForViewOrErrors(projectIdOrKey).left().map(this.asErrorResponse(Response.Status.BAD_REQUEST)).left().on((Function)new Function<Project, Response>(){

            public Response apply(Project project) {
                Collection issueTypesForProject = ProjectResource.this.issueTypeSchemeManager.getIssueTypesForProject(project);
                ArrayList issueTypesWithStatuses = Lists.newArrayList();
                for (IssueType issueType : issueTypesForProject) {
                    JiraWorkflow workflow = ProjectResource.this.workflowManager.getWorkflow(project.getId(), issueType.getId());
                    ImmutableList statusJsonBeans = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)workflow.getLinkedStatusObjects(), (Function)new Function<Status, StatusJsonBean>(){

                        public StatusJsonBean apply(Status status) {
                            return ProjectResource.this.statusHelper.createStatusBean(status, ProjectResource.this.uriInfo, StatusResource.class);
                        }
                    }));
                    issueTypesWithStatuses.add(ProjectResource.this.createIssueTypeWithStatuses(issueType, (ImmutableList<StatusJsonBean>)statusJsonBeans));
                }
                return Response.ok((Object)issueTypesWithStatuses).cacheControl(CacheControl.NO_CACHE).build();
            }
        });
    }

    private void throwWebException(com.atlassian.jira.util.ErrorCollection errorCollection) {
        throw new RESTException(ErrorCollection.of(errorCollection));
    }

    private IssueTypeWithStatusJsonBean createIssueTypeWithStatuses(IssueType issueType, ImmutableList<StatusJsonBean> statusJsonBeans) {
        return new IssueTypeWithStatusJsonBean(this.uriBuilder.build(this.uriInfo, IssueTypeResource.class, issueType.getId()).toString(), issueType.getId(), issueType.getName(), issueType.isSubTask(), (Collection<StatusJsonBean>)statusJsonBeans);
    }

    private Either<Response, Project> getProjectForView(String projectIdOrKey) {
        return this.getEitherProjectForViewOrErrors(projectIdOrKey).left().map(this.asErrorResponse(Response.Status.NOT_FOUND));
    }

    private Either<Response, Project> getProjectForEdit(String projectIdOrKey) {
        return this.getEitherProjectForEditOrErrors(projectIdOrKey).left().map(this.asErrorResponse(Response.Status.NOT_FOUND));
    }

    private Either<ErrorCollection, Project> getEitherProjectForViewOrErrors(String projectIdOrKey) {
        return this.getEitherProjectOrErrors(projectIdOrKey, ProjectAction.VIEW_PROJECT);
    }

    private Either<ErrorCollection, Project> getEitherProjectForEditOrErrors(String projectIdOrKey) {
        return this.getEitherProjectOrErrors(projectIdOrKey, ProjectAction.EDIT_PROJECT_CONFIG);
    }

    private Either<ErrorCollection, Project> getEitherProjectOrErrors(String projectIdOrKey, ProjectAction action) {
        ProjectService.GetProjectResult projectResult = this.projectFinder.getGetProjectForActionByIdOrKey(this.authContext.getUser(), projectIdOrKey, action);
        if (!projectResult.isValid()) {
            return Either.left((Object)ErrorCollection.of(projectResult.getErrorCollection()));
        }
        return Either.right((Object)projectResult.getProject());
    }

    private Function<ErrorCollection, Response> asErrorResponse(final Response.Status status) {
        return new Function<ErrorCollection, Response>(){

            public Response apply(ErrorCollection errors) {
                return Response.status((Response.Status)status).entity((Object)errors).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
            }
        };
    }
}

