/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.config.ConstantsService;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.exception.ServerErrorWebException;
import com.atlassian.jira.rest.v2.issue.IssueTypeBeanBuilder;
import com.atlassian.jira.rest.v2.issue.context.ContextUriInfo;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="issuetype")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IssueTypeResource {
    private JiraAuthenticationContext authContext;
    private ConstantsService constantsService;
    private ContextUriInfo contextUriInfo;
    private JiraBaseUrls jiraBaseUrls;

    private IssueTypeResource() {
    }

    public IssueTypeResource(JiraAuthenticationContext authContext, ConstantsService constantsService, VelocityRequestContextFactory velocityRequestContextFactory, ContextUriInfo contextUriInfo, JiraBaseUrls jiraBaseUrls) {
        this.authContext = authContext;
        this.constantsService = constantsService;
        this.contextUriInfo = contextUriInfo;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    @GET
    public Response getIssueAllTypes() {
        ServiceOutcome outcome = this.constantsService.getAllIssueTypes(this.authContext.getLoggedInUser());
        if (!outcome.isValid()) {
            throw new ServerErrorWebException(ErrorCollection.of(outcome.getErrorCollection()));
        }
        ArrayList<IssueTypeJsonBean> beans = new ArrayList<IssueTypeJsonBean>();
        for (IssueType issueType : (Collection)outcome.getReturnedValue()) {
            IssueTypeJsonBean issueTypeBean = this.createIssueTypeBean(issueType);
            beans.add(issueTypeBean);
        }
        return Response.ok(beans).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{id}")
    public Response getIssueType(@PathParam(value="id") String issueTypeId) {
        ServiceOutcome outcome = this.constantsService.getIssueTypeById(this.authContext.getLoggedInUser(), issueTypeId);
        if (!outcome.isValid()) {
            throw new NotFoundWebException(ErrorCollection.of(outcome.getErrorCollection()));
        }
        IssueType returnedValue = (IssueType)outcome.getReturnedValue();
        IssueTypeJsonBean bean = this.createIssueTypeBean(returnedValue);
        return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
    }

    private IssueTypeJsonBean createIssueTypeBean(IssueType returnedValue) {
        return new IssueTypeBeanBuilder().jiraBaseUrls(this.jiraBaseUrls).context(this.contextUriInfo).issueType(returnedValue).build();
    }
}

