/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.beans.CommentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinkJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinkTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueRefJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.StatusJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.WorklogJsonBean;
import com.atlassian.jira.rest.api.issue.BulkOperationErrorResult;
import com.atlassian.jira.rest.api.issue.FieldOperation;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.IssuesCreateResponse;
import com.atlassian.jira.rest.api.issue.IssuesUpdateRequest;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.rest.api.issue.TimeTracking;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.issue.AttachmentBean;
import com.atlassian.jira.rest.v2.issue.CreateMetaBean;
import com.atlassian.jira.rest.v2.issue.CreateMetaIssueTypeBean;
import com.atlassian.jira.rest.v2.issue.CreateMetaProjectBean;
import com.atlassian.jira.rest.v2.issue.Examples;
import com.atlassian.jira.rest.v2.issue.FieldMetaBean;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.jira.rest.v2.issue.TimeTrackingBean;
import com.atlassian.jira.rest.v2.issue.WatchersBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectBean;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IssueResourceExamples {
    public static final IssueUpdateRequest CREATE_REQUEST;
    public static final IssueUpdateRequest CREATE_REQUEST_SECOND_ELEMENT;
    public static final IssuesUpdateRequest BULK_CREATE_REQUEST;
    public static final IssueCreateResponse CREATE_RESPONSE_200;
    private static final IssueCreateResponse CREATE_RESPONSE_200_SECOND_ELEMENT;
    public static final ErrorCollection CREATE_RESPONSE_400;
    public static final IssuesCreateResponse BULK_CRETE_RESPONSE_200;
    public static final BulkOperationErrorResult BULK_CREATE_RESPONSE_400;
    public static final IssueBean ISSUE_SHORT;
    public static final IssueLinkTypeJsonBean SUBTASK_ISSUE_LINK_TYPE;
    public static final IssueLinkTypeJsonBean DEPENDENT_ISSUE_LINK_TYPE;
    public static final IssueBean GET_RESPONSE_200;
    public static final CreateMetaBean GET_CREATEMETA_RESPONSE_200;

    static {
        CREATE_RESPONSE_200 = new IssueCreateResponse().id("10000").key("TST-24").self(Examples.restURI("issue/10000").toString());
        CREATE_RESPONSE_200_SECOND_ELEMENT = new IssueCreateResponse().id("10001").key("TST-25").self(Examples.restURI("issue/10001").toString());
        CREATE_RESPONSE_400 = ErrorCollection.of("Field 'priority' is required");
        BULK_CRETE_RESPONSE_200 = new IssuesCreateResponse((List<IssueCreateResponse>)ImmutableList.of((Object)CREATE_RESPONSE_200, (Object)CREATE_RESPONSE_200_SECOND_ELEMENT), Collections.<BulkOperationErrorResult>emptyList());
        BULK_CREATE_RESPONSE_400 = new BulkOperationErrorResult(400, CREATE_RESPONSE_400, 3);
        ISSUE_SHORT = new IssueBean(10001L, "HSP-1", Examples.restURI("issue/10001"));
        SUBTASK_ISSUE_LINK_TYPE = new IssueLinkTypeJsonBean(Long.valueOf(10000L), "", "Parent", "Sub-task", null);
        DEPENDENT_ISSUE_LINK_TYPE = new IssueLinkTypeJsonBean(Long.valueOf(10000L), "Dependent", "depends on", "is depended by", null);
        StatusJsonBean status = new StatusJsonBean().name("Open").iconUrl(Examples.jiraURI("/images/icons/statuses/open.png").toString());
        IssueBean issue = new IssueBean(10002L, "EX-1", Examples.restURI("issue/10002"));
        issue.addRawField("updated", "updated", null, new Date(1L));
        issue.addRawField("description", "description", null, "example bug report");
        issue.addRawField("project", "project", null, ProjectBean.SHORT_DOC_EXAMPLE_1);
        issue.addRawField("timetracking", "timetracking", null, new TimeTrackingBean(600L, 200L, 400L));
        issue.addRawField("attachment", "attachment", null, CollectionBuilder.list((Object[])new AttachmentBean[]{AttachmentBean.DOC_EXAMPLE}));
        issue.addRawField("comment", "comment", null, CollectionBuilder.list((Object[])new CommentJsonBean[]{CommentJsonBean.DOC_EXAMPLE}));
        issue.addRawField("worklog", "worklog", null, CollectionBuilder.list((Object[])new WorklogJsonBean[]{WorklogJsonBean.DOC_EXAMPLE}));
        issue.addRawField("sub-tasks", "sub-tasks", null, CollectionBuilder.list((Object[])new IssueLinkJsonBean[]{new IssueLinkJsonBean().id("10000").outwardIssue(new IssueRefJsonBean("10003", "EX-2", Examples.restURI("issue/EX-2"), new IssueRefJsonBean.Fields().status(status))).type(SUBTASK_ISSUE_LINK_TYPE)}));
        issue.addRawField("issuelinks", "issuelinks", null, CollectionBuilder.list((Object[])new IssueLinkJsonBean[]{new IssueLinkJsonBean().id("10001").type(DEPENDENT_ISSUE_LINK_TYPE).outwardIssue(new IssueRefJsonBean("10004L", "PRJ-2", Examples.restURI("issue/PRJ-2"), new IssueRefJsonBean.Fields().status(status))), new IssueLinkJsonBean().id("10002").type(DEPENDENT_ISSUE_LINK_TYPE).inwardIssue(new IssueRefJsonBean("10004", "PRJ-3", Examples.restURI("issue/PRJ-3"), new IssueRefJsonBean.Fields().status(status)))}));
        issue.addRawField("watcher", "watcher", null, WatchersBean.DOC_EXAMPLE);
        GET_RESPONSE_200 = issue;
        CREATE_REQUEST = new IssueUpdateRequest().fields(new IssueFields().project(ResourceRef.withId("10000")).issueType(ResourceRef.withId("10000")).priority(ResourceRef.withId("20000")).reporter(ResourceRef.withName("smithers")).assignee(ResourceRef.withName("homer")).summary("something's wrong").labels(Arrays.asList("bugfix", "blitz_test")).timeTracking(new TimeTracking("10", "5")).securityLevel(ResourceRef.withId("10000")).versions(ResourceRef.withId("10000")).environment("environment").description("description").dueDate("2011-03-11").fixVersions(ResourceRef.withId("10001")).components(ResourceRef.withId("10000")).customField(10000L, (Object)"09/Jun/81").customField(20000L, (Object)"06/Jul/11 3:25 PM").customField(30000L, (Object)new String[]{"10000", "10002"}).customField(40000L, (Object)"this is a text field").customField(50000L, (Object)"this is a text area. big text.").customField(60000L, (Object)"jira-developers").customField(70000L, (Object)new String[]{"jira-administrators", "jira-users"}).customField(80000L, Collections.singletonMap("value", "red")));
        CREATE_REQUEST_SECOND_ELEMENT = new IssueUpdateRequest().fields(new IssueFields().project(ResourceRef.withId("1000")).issueType(ResourceRef.withId("10000")).priority(ResourceRef.withId("20000")).reporter(ResourceRef.withName("kosecki")).assignee(ResourceRef.withName("jerry")).summary("something's very wrong").labels(Arrays.asList("new_release")).timeTracking(new TimeTracking("15", "5")).securityLevel(ResourceRef.withId("10000")).versions(ResourceRef.withId("10000")).environment("environment").description("description").dueDate("2011-04-16").fixVersions(ResourceRef.withId("10001")).components(ResourceRef.withId("10000")).customField(10000L, (Object)"09/Jun/81").customField(20000L, (Object)"06/Jul/11 3:25 PM").customField(30000L, (Object)new String[]{"10000", "10002"}).customField(40000L, (Object)"this is a text field").customField(50000L, (Object)"this is a text area. big text.").customField(60000L, (Object)"jira-developers").customField(70000L, (Object)new String[]{"jira-administrators", "jira-users"}).customField(80000L, Collections.singletonMap("value", "red")));
        Map worklog = MapBuilder.newBuilder().add((Object)"started", (Object)"2011-07-05T11:05:00.000+0000").add((Object)"timeSpent", (Object)"60m").toMap();
        CREATE_REQUEST.update(MapBuilder.build((Object)"worklog", Arrays.asList(new FieldOperation().operation("add").value(worklog))));
        BULK_CREATE_REQUEST = new IssuesUpdateRequest((List<IssueUpdateRequest>)ImmutableList.of((Object)CREATE_REQUEST, (Object)CREATE_REQUEST_SECOND_ELEMENT));
        HashMap<String, FieldMetaBean> fields = new HashMap<String, FieldMetaBean>();
        fields.put("issuetype", new FieldMetaBean(true, false, null, "Issue Type", null, Lists.newArrayList((Object[])new String[]{StandardOperation.SET.getName()}), null));
        CreateMetaIssueTypeBean issueType = new CreateMetaIssueTypeBean(Examples.restURI("issueType/1").toString(), "1", "Bug", "An error in the code", false, Examples.jiraURI("images/icons/issuetypes/bug.png").toString(), null);
        issueType.setFields(fields);
        Map projectAvatarUrls = MapBuilder.newBuilder().add((Object)"16x16", (Object)Examples.jiraURI("secure/projectavatar?size=xsmall&pid=10000&avatarId=10011").toString()).add((Object)"24x24", (Object)Examples.jiraURI("secure/projectavatar?size=small&pid=10000&avatarId=10011").toString()).add((Object)"32x32", (Object)Examples.jiraURI("secure/projectavatar?size=medium&pid=10000&avatarId=10011").toString()).add((Object)"48x48", (Object)Examples.jiraURI("secure/projectavatar?pid=10000&avatarId=10011").toString()).toMap();
        CreateMetaProjectBean project = new CreateMetaProjectBean(Examples.restURI("project/EX").toString(), "10000", "EX", "Example Project", projectAvatarUrls, Arrays.asList(issueType));
        GET_CREATEMETA_RESPONSE_200 = new CreateMetaBean(Arrays.asList(project));
    }
}

