/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.issue.vote.VoteService;
import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.bc.issue.watcher.WatchingDisabledException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.rest.json.beans.CommentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.NotificationJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.WorklogJsonBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItemImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.notification.AdhocNotificationService;
import com.atlassian.jira.notification.AdhocNotificationServiceImpl;
import com.atlassian.jira.notification.NotificationBuilder;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.issue.RemoteIssueLinkCreateOrUpdateRequest;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.v2.issue.AssignIssueResource;
import com.atlassian.jira.rest.v2.issue.CommentResource;
import com.atlassian.jira.rest.v2.issue.CreateIssueResource;
import com.atlassian.jira.rest.v2.issue.CreateMetaBean;
import com.atlassian.jira.rest.v2.issue.DeleteIssueResource;
import com.atlassian.jira.rest.v2.issue.EditMetaBean;
import com.atlassian.jira.rest.v2.issue.FieldMetaBean;
import com.atlassian.jira.rest.v2.issue.IncludedFields;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.jira.rest.v2.issue.IssueFinder;
import com.atlassian.jira.rest.v2.issue.IssueUpdateBean;
import com.atlassian.jira.rest.v2.issue.IssuesUpdateBean;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.issue.RemoteIssueLinkResource;
import com.atlassian.jira.rest.v2.issue.TransitionBean;
import com.atlassian.jira.rest.v2.issue.TransitionsMetaBean;
import com.atlassian.jira.rest.v2.issue.UpdateIssueResource;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.rest.v2.issue.VoteBean;
import com.atlassian.jira.rest.v2.issue.WatchersBean;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.rest.v2.issue.context.ContextUriInfo;
import com.atlassian.jira.rest.v2.issue.watcher.WatcherOps;
import com.atlassian.jira.rest.v2.issue.worklog.WorklogResource;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.mail.MailFactory;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;

@Path(value="issue")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IssueResource {
    private IssueFinder issueFinder;
    private UserManager userManager;
    private IssueWorkflowManager issueWorkflowManager;
    private JiraAuthenticationContext authContext;
    private VoteService voteService;
    private I18nHelper i18n;
    private WatcherOps watcherOps;
    private WatcherService watcherService;
    private AdhocNotificationService notificationService;
    private BeanBuilderFactory beanBuilderFactory;
    private ContextUriInfo contextUriInfo;
    private AssignIssueResource assignIssueResource;
    private CreateIssueResource createIssueResource;
    private DeleteIssueResource deleteIssueResource;
    private UpdateIssueResource updateIssueResource;
    private RemoteIssueLinkResource remoteIssueLinkResource;
    private WorklogResource worklogResource;
    private CommentResource commentResource;
    private JiraBaseUrls jiraBaseUrls;

    private IssueResource() {
    }

    public IssueResource(JiraAuthenticationContext authContext, UserManager userManager, VoteService voteService, I18nHelper i18n, WatcherOps watcherOps, WatcherService watcherService, BeanBuilderFactory beanBuilderFactory, ContextUriInfo contextUriInfo, IssueFinder issueFinder, CreateIssueResource createIssueResource, UpdateIssueResource updateIssueResource, DeleteIssueResource deleteIssueResource, RemoteIssueLinkResource remoteIssueLinkResource, WorklogResource worklogResource, CommentResource commentResource, IssueWorkflowManager issueWorkflowManager, AssignIssueResource assignIssueResource, AdhocNotificationService notificationService, JiraBaseUrls jiraBaseUrls) {
        this.jiraBaseUrls = jiraBaseUrls;
        this.authContext = (JiraAuthenticationContext)Assertions.notNull((Object)authContext);
        this.userManager = (UserManager)Assertions.notNull((Object)userManager);
        this.voteService = (VoteService)Assertions.notNull((Object)voteService);
        this.i18n = (I18nHelper)Assertions.notNull((Object)i18n);
        this.watcherOps = (WatcherOps)Assertions.notNull((Object)watcherOps);
        this.watcherService = (WatcherService)Assertions.notNull((Object)watcherService);
        this.beanBuilderFactory = (BeanBuilderFactory)Assertions.notNull((Object)beanBuilderFactory);
        this.contextUriInfo = (ContextUriInfo)Assertions.notNull((Object)contextUriInfo);
        this.issueFinder = (IssueFinder)Assertions.notNull((Object)issueFinder);
        this.createIssueResource = (CreateIssueResource)Assertions.notNull((Object)createIssueResource);
        this.updateIssueResource = (UpdateIssueResource)Assertions.notNull((Object)updateIssueResource);
        this.deleteIssueResource = (DeleteIssueResource)Assertions.notNull((Object)deleteIssueResource);
        this.remoteIssueLinkResource = (RemoteIssueLinkResource)Assertions.notNull((Object)remoteIssueLinkResource);
        this.worklogResource = (WorklogResource)Assertions.notNull((Object)worklogResource);
        this.commentResource = (CommentResource)Assertions.notNull((Object)commentResource);
        this.issueWorkflowManager = (IssueWorkflowManager)Assertions.notNull((Object)issueWorkflowManager);
        this.assignIssueResource = (AssignIssueResource)Assertions.notNull((Object)assignIssueResource);
        this.notificationService = (AdhocNotificationService)Assertions.notNull((Object)notificationService);
    }

    @GET
    @Path(value="{issueIdOrKey}/transitions")
    public Response getTransitions(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="transitionId") String transitionId) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        try {
            if (StringUtils.isNotBlank((String)transitionId)) {
                Integer.valueOf(transitionId);
            }
        }
        catch (NumberFormatException e) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.i18n.getText("rest.transition.error.id.not.integer"));
        }
        List actions = this.issueWorkflowManager.getSortedAvailableActions((Issue)issue);
        ArrayList<TransitionBean> transitions = new ArrayList<TransitionBean>();
        for (ActionDescriptor action : actions) {
            if (StringUtils.isNotBlank((String)transitionId) && !Integer.valueOf(transitionId).equals(action.getId())) continue;
            TransitionBean transitionMetaBean = this.beanBuilderFactory.newTransitionMetaBeanBuilder().issue((Issue)issue).action(action).build();
            transitions.add(transitionMetaBean);
        }
        TransitionsMetaBean transitionsMetaBean = new TransitionsMetaBean(transitions);
        return Response.ok((Object)transitionsMetaBean).cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="{issueIdOrKey}/transitions")
    public Response doTransition(@PathParam(value="issueIdOrKey") String issueIdOrKey, IssueUpdateBean issueUpdateBean) {
        if (issueUpdateBean.getTransition() == null) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.i18n.getText("rest.transition.error.no.transition"));
        }
        try {
            Integer.parseInt(issueUpdateBean.getTransition().getId());
        }
        catch (NumberFormatException e) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.i18n.getText("rest.transition.error.id.not.integer"));
        }
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.updateIssueResource.transitionIssue((Issue)issue, issueUpdateBean);
    }

    @DELETE
    @Path(value="{issueIdOrKey}/votes")
    public Response removeVote(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        VoteService.VoteValidationResult validationResult = this.voteService.validateRemoveVote(this.authContext.getLoggedInUser(), this.authContext.getLoggedInUser(), (Issue)issue);
        if (!validationResult.isValid()) {
            throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(validationResult.getErrorCollection()));
        }
        this.voteService.removeVote(this.authContext.getLoggedInUser(), validationResult);
        return IssueResource.NO_CONTENT();
    }

    @POST
    @Path(value="{issueIdOrKey}/votes")
    public Response addVote(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        VoteService.VoteValidationResult validationResult = this.voteService.validateAddVote(this.authContext.getLoggedInUser(), this.authContext.getLoggedInUser(), (Issue)issue);
        if (!validationResult.isValid()) {
            throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(validationResult.getErrorCollection()));
        }
        this.voteService.addVote(this.authContext.getLoggedInUser(), validationResult);
        return IssueResource.NO_CONTENT();
    }

    @GET
    @Path(value="{issueIdOrKey}/votes")
    public Response getVotes(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        User user = this.authContext.getLoggedInUser();
        if (this.voteService.isVotingEnabled()) {
            boolean hasVoted = this.voteService.hasVoted((Issue)issue, user);
            ServiceOutcome outcome = this.voteService.viewVoters((Issue)issue, user);
            ArrayList voters = outcome.isValid() ? new ArrayList(Transformed.collection((Collection)((Collection)outcome.getReturnedValue()), (Function)new Function<User, UserBean>(){

                public UserBean get(User input) {
                    return new UserBeanBuilder(IssueResource.this.jiraBaseUrls).user(input).buildShort();
                }
            })) : new ArrayList();
            URI selfUri = this.contextUriInfo.getBaseUriBuilder().path(IssueResource.class).path(issue.getKey()).path("votes").build(new Object[0]);
            VoteBean voteBean = new VoteBean(selfUri, hasVoted, issue.getVotes(), voters);
            return Response.ok((Object)voteBean).cacheControl(CacheControl.never()).build();
        }
        throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(this.i18n.getText("issue.operations.voting.disabled")));
    }

    @GET
    @Path(value="{issueIdOrKey}")
    public Response getIssue(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="fields") List<StringList> fields, @QueryParam(value="expand") String expand) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        IncludedFields include = IncludedFields.includeAllByDefault(fields);
        IssueBean bean = this.beanBuilderFactory.newIssueBeanBuilder((Issue)issue, include).expand(expand).build();
        return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{issueIdOrKey}/watchers")
    public Response getIssueWatchers(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        WatchersBean watchers = this.watcherOps.getWatchers((Issue)issue, this.authContext.getLoggedInUser());
        return Response.ok((Object)watchers).cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="{issueIdOrKey}/watchers")
    public Response addWatcher(@PathParam(value="issueIdOrKey") String issueIdOrKey, String userName) {
        try {
            User watchUser = this.getUserFromPost(userName);
            if (watchUser == null) {
                return this.BAD_REQUEST();
            }
            MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
            ServiceOutcome outcome = this.watcherService.addWatcher((Issue)issue, this.authContext.getLoggedInUser(), watchUser);
            if (!outcome.isValid()) {
                throw new NotAuthorisedWebException(ErrorCollection.of(outcome.getErrorCollection()));
            }
            return IssueResource.NO_CONTENT();
        }
        catch (WatchingDisabledException e) {
            throw new NotFoundWebException(e);
        }
    }

    private User getUserFromPost(String body) {
        if (StringUtils.isEmpty((String)body)) {
            return this.authContext.getLoggedInUser();
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonFactory factory = mapper.getJsonFactory();
        try {
            JsonParser jp = factory.createJsonParser(body);
            JsonNode obj = mapper.readTree(jp);
            if (obj.isTextual()) {
                String userName = obj.getTextValue();
                if (StringUtils.isEmpty((String)userName)) {
                    return this.authContext.getLoggedInUser();
                }
                return this.userManager.getUser(userName);
            }
            throw new WebApplicationException(this.BAD_REQUEST());
        }
        catch (JsonParseException e) {
            throw new WebApplicationException((Throwable)e, this.BAD_REQUEST());
        }
        catch (JsonProcessingException e) {
            throw new WebApplicationException((Throwable)e, this.BAD_REQUEST());
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, this.BAD_REQUEST());
        }
    }

    @DELETE
    @Path(value="{issueIdOrKey}/watchers")
    public Response removeWatcher(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="username") String userName) {
        try {
            if (userName == null) {
                return this.BAD_REQUEST();
            }
            User unwatchUser = this.userManager.getUserEvenWhenUnknown(userName);
            MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
            ServiceOutcome outcome = this.watcherService.removeWatcher((Issue)issue, this.authContext.getLoggedInUser(), unwatchUser);
            if (!outcome.isValid()) {
                throw new NotAuthorisedWebException(ErrorCollection.of(outcome.getErrorCollection()));
            }
            return IssueResource.NO_CONTENT();
        }
        catch (WatchingDisabledException e) {
            throw new NotFoundWebException();
        }
    }

    @POST
    public Response createIssue(IssueUpdateBean createRequest) {
        return this.createIssueResource.createIssue(createRequest, this.contextUriInfo);
    }

    @POST
    @Path(value="/bulk")
    public Response createIssues(IssuesUpdateBean createRequest) {
        return this.createIssueResource.createIssues(createRequest, this.contextUriInfo);
    }

    @DELETE
    @Path(value="{issueIdOrKey}")
    public Response deleteIssue(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="deleteSubtasks") String deleteSubtasks) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.deleteIssueResource.deleteIssue((Issue)issue, deleteSubtasks, this.contextUriInfo);
    }

    @GET
    @Path(value="createmeta")
    public Response getCreateIssueMeta(@QueryParam(value="projectIds") List<StringList> projectIds, @QueryParam(value="projectKeys") List<StringList> projectKeys, @QueryParam(value="issuetypeIds") List<StringList> issuetypeIds, @QueryParam(value="issuetypeNames") List<String> issuetypeNames) {
        CreateMetaBean bean = this.beanBuilderFactory.newCreateMetaBeanBuilder().projectIds(projectIds).projectKeys(projectKeys).issueTypeIds(issuetypeIds).issueTypeNames(issuetypeNames).build();
        return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{issueIdOrKey}/editmeta")
    public Response getEditIssueMeta(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        EditMetaBean bean = this.beanBuilderFactory.newEditMetaBeanBuilder().issue((Issue)issue).build();
        return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
    }

    @PUT
    @Path(value="{issueIdOrKey}")
    public Response editIssue(@PathParam(value="issueIdOrKey") String issueIdOrKey, IssueUpdateBean updateRequest) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.updateIssueResource.editIssue((Issue)issue, updateRequest);
    }

    @PUT
    @Path(value="{issueIdOrKey}/assignee")
    public Response assign(@PathParam(value="issueIdOrKey") String issueIdOrKey, UserBean assigneeBean) {
        String assigneeName = assigneeBean == null ? null : assigneeBean.getName();
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.assignIssueResource.assignIssue((Issue)issue, assigneeName);
    }

    @GET
    @Path(value="{issueIdOrKey}/remotelink")
    public Response getRemoteIssueLinks(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="globalId") String globalId) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.remoteIssueLinkResource.getRemoteIssueLinks((Issue)issue, globalId);
    }

    @GET
    @Path(value="{issueIdOrKey}/remotelink/{linkId}")
    public Response getRemoteIssueLinkById(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="linkId") String linkId) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.remoteIssueLinkResource.getRemoteIssueLinkById((Issue)issue, linkId);
    }

    @POST
    @Path(value="{issueIdOrKey}/remotelink")
    public Response createOrUpdateRemoteIssueLink(@PathParam(value="issueIdOrKey") String issueIdOrKey, RemoteIssueLinkCreateOrUpdateRequest request) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.remoteIssueLinkResource.createOrUpdateRemoteIssueLink((Issue)issue, request, this.contextUriInfo);
    }

    @PUT
    @Path(value="{issueIdOrKey}/remotelink/{linkId}")
    public Response updateRemoteIssueLink(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="linkId") String linkId, RemoteIssueLinkCreateOrUpdateRequest updateRequest) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.remoteIssueLinkResource.updateRemoteIssueLink((Issue)issue, linkId, updateRequest);
    }

    @DELETE
    @Path(value="{issueIdOrKey}/remotelink/{linkId}")
    public Response deleteRemoteIssueLinkById(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="linkId") String remoteIssueLinkId) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.remoteIssueLinkResource.deleteRemoteIssueLinkById((Issue)issue, remoteIssueLinkId);
    }

    @DELETE
    @Path(value="{issueIdOrKey}/remotelink")
    public Response deleteRemoteIssueLinkByGlobalId(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="globalId") String globalId) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.remoteIssueLinkResource.deleteRemoteIssueLinkByGlobalId((Issue)issue, globalId);
    }

    @GET
    @Path(value="{issueIdOrKey}/worklog")
    public Response getIssueWorklog(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.worklogResource.getIssueWorklogs((Issue)issue);
    }

    @GET
    @Path(value="{issueIdOrKey}/worklog/{id}")
    public Response getWorklog(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String worklogId) {
        return this.worklogResource.getWorklog(worklogId);
    }

    @PUT
    @Path(value="{issueIdOrKey}/worklog/{id}")
    public Response updateWorklog(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String worklogId, @QueryParam(value="adjustEstimate") String adjustEstimate, @QueryParam(value="newEstimate") String newEstimate, WorklogJsonBean request) {
        if (request.getId() != null && !request.getId().equals(worklogId)) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.i18n.getText("rest.worklog.error.id.mismatch"));
        }
        request.setId(worklogId);
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.worklogResource.updateWorklog((Issue)issue, request, new WorklogResource.WorklogAdjustmentRequest(adjustEstimate, newEstimate, null, null), this.contextUriInfo);
    }

    @DELETE
    @Path(value="{issueIdOrKey}/worklog/{id}")
    public Response deleteWorklog(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String worklogId, @QueryParam(value="adjustEstimate") String adjustEstimate, @QueryParam(value="newEstimate") String newEstimate, @QueryParam(value="increaseBy") String increaseBy) {
        WorklogJsonBean request = new WorklogJsonBean();
        request.setId(worklogId);
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.worklogResource.deleteWorklog((Issue)issue, request, new WorklogResource.WorklogAdjustmentRequest(adjustEstimate, newEstimate, null, increaseBy), this.contextUriInfo);
    }

    @POST
    @Path(value="{issueIdOrKey}/worklog")
    public Response addWorklog(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="adjustEstimate") String adjustEstimate, @QueryParam(value="newEstimate") String newEstimate, @QueryParam(value="reduceBy") String reduceBy, WorklogJsonBean request) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        return this.worklogResource.addWorklog((Issue)issue, request, new WorklogResource.WorklogAdjustmentRequest(adjustEstimate, newEstimate, reduceBy, null), this.contextUriInfo);
    }

    @GET
    @Path(value="{issueIdOrKey}/comment")
    public Response getComments(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="expand") String expand) {
        return this.commentResource.getComments(issueIdOrKey, expand);
    }

    @GET
    @Path(value="{issueIdOrKey}/comment/{id}")
    public Response getComments(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String commentId, @QueryParam(value="expand") String expand) {
        return this.commentResource.getComment(issueIdOrKey, commentId, expand);
    }

    @PUT
    @Path(value="{issueIdOrKey}/comment/{id}")
    public Response updateComment(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String commentId, @QueryParam(value="expand") String expand, CommentJsonBean request) {
        return this.commentResource.updateComment(issueIdOrKey, commentId, expand, request);
    }

    @DELETE
    @Path(value="{issueIdOrKey}/comment/{id}")
    public Response deleteComment(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="id") String commentId) {
        return this.commentResource.deleteComment(issueIdOrKey, commentId);
    }

    @POST
    @Path(value="{issueIdOrKey}/comment")
    public Response addComment(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="expand") String expand, CommentJsonBean request) {
        return this.commentResource.addComment(issueIdOrKey, expand, request);
    }

    @POST
    @Path(value="{issueIdOrKey}/notify")
    public Response notify(@PathParam(value="issueIdOrKey") String issueIdOrKey, NotificationJsonBean request) {
        AdhocNotificationService.ValidateNotificationResult result;
        if (MailFactory.getSettings().isSendingDisabled()) {
            throw new RESTException(Response.Status.FORBIDDEN, ErrorCollection.of(this.i18n.getText("rest.error.outgoing.mail.disabled")));
        }
        if (MailFactory.getServerManager().getDefaultSMTPMailServer() == null) {
            throw new RESTException(Response.Status.FORBIDDEN, ErrorCollection.of(this.i18n.getText("rest.error.no.smtp.defined")));
        }
        User user = this.authContext.getLoggedInUser();
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        ErrorCollection errors = ErrorCollection.of(new String[0]);
        ServiceOutcome notificationBuilder = AdhocNotificationServiceImpl.makeBuilder((NotificationBuilder)this.notificationService.makeBuilder(), (NotificationJsonBean)request, (I18nHelper)this.i18n);
        if (!notificationBuilder.isValid()) {
            errors.addErrorCollection(notificationBuilder.getErrorCollection());
        }
        if (!(result = this.notificationService.validateNotification((NotificationBuilder)notificationBuilder.getReturnedValue(), user, (Issue)issue)).isValid()) {
            throw new RESTException(Response.Status.BAD_REQUEST, errors.addErrorCollection(result.getErrorCollection()));
        }
        this.notificationService.sendNotification(result);
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    protected Response BAD_REQUEST() {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).build();
    }

    protected static Response NO_CONTENT() {
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    public Collection<FieldMetaBean> getRequiredFields(FieldScreenRenderer fieldScreenRenderer, Issue issue) {
        ArrayList<FieldMetaBean> fields = new ArrayList<FieldMetaBean>();
        for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderer.getFieldScreenRenderTabs()) {
            for (Object fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItemsForProcessing()) {
                OrderableField orderableField;
                if (!fieldScreenRenderLayoutItem.isShow(issue) || !"resolution".equals((orderableField = fieldScreenRenderLayoutItem.getOrderableField()).getId())) continue;
                fieldScreenRenderLayoutItem = new FieldScreenRenderLayoutItemImpl(fieldScreenRenderLayoutItem.getFieldScreenLayoutItem(), fieldScreenRenderLayoutItem.getFieldLayoutItem()){

                    public boolean isRequired() {
                        return true;
                    }
                };
            }
        }
        return fields;
    }
}

