/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.fugue.Function2;
import com.atlassian.jira.bc.issue.properties.IssuePropertyService;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBeanSelfFunctions;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.v2.entity.property.BasePropertyWithKeyResource;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="issue/{issueIdOrKey}/properties")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IssuePropertyResource {
    private final BasePropertyWithKeyResource<Issue> delegate;

    public IssuePropertyResource(IssuePropertyService issuePropertyService, JiraAuthenticationContext authContext, JiraBaseUrls jiraBaseUrls, I18nHelper i18n) {
        this.delegate = new BasePropertyWithKeyResource(issuePropertyService, authContext, jiraBaseUrls, i18n, (Predicate<String>)new IssueKey.IsValidIssueKeyPredicate(), (Function2<Long, String, String>)new EntityPropertyBeanSelfFunctions.IssuePropertySelfFunction(), EntityPropertyType.ISSUE_PROPERTY);
    }

    @ExperimentalApi
    @GET
    public Response getPropertiesKeys(@PathParam(value="issueIdOrKey") String issueIdOrKey) {
        return this.delegate.getPropertiesKeys(issueIdOrKey);
    }

    @ExperimentalApi
    @PUT
    @Path(value="/{propertyKey}")
    public Response setProperty(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="propertyKey") String issuePropertyKey, @Context HttpServletRequest request) {
        return this.delegate.setProperty(issueIdOrKey, issuePropertyKey, request);
    }

    @ExperimentalApi
    @GET
    @Path(value="/{propertyKey}")
    public Response getProperty(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="propertyKey") String issuePropertyKey) {
        return this.delegate.getProperty(issueIdOrKey, issuePropertyKey);
    }

    @ExperimentalApi
    @DELETE
    @Path(value="/{propertyKey}")
    public Response deleteProperty(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="propertyKey") String propertyKey) {
        return this.delegate.deleteProperty(issueIdOrKey, propertyKey);
    }
}

