/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.ProjectSystemField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinksBeanBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinksBeanBuilderFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueRefJsonBean;
import com.atlassian.jira.rest.v2.issue.EditMetaBean;
import com.atlassian.jira.rest.v2.issue.IncludedFields;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.jira.rest.v2.issue.IssueResource;
import com.atlassian.jira.rest.v2.issue.OpsbarBeanBuilder;
import com.atlassian.jira.rest.v2.issue.ResourceUriBuilder;
import com.atlassian.jira.rest.v2.issue.TransitionBean;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.rest.v2.issue.context.ContextUriInfo;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.UriBuilder;
import org.apache.log4j.Logger;

public class IssueBeanBuilder {
    private static final Logger LOG = Logger.getLogger(IssueBeanBuilder.class);
    private final FieldLayoutManager fieldLayoutManager;
    private final JiraAuthenticationContext authContext;
    private final FieldManager fieldManager;
    private final ResourceUriBuilder resourceUriBuilder;
    private final BeanBuilderFactory beanBuilderFactory;
    private final ContextUriInfo contextUriInfo;
    private final IssueLinksBeanBuilderFactory issueLinkBeanBuilderFactory;
    private final IssueWorkflowManager issueWorkflowManager;
    private IncludedFields fieldsToInclude;
    private String expand;
    private UriBuilder uriBuilder;
    private final Issue issue;
    private static final Function<FieldLayoutItem, Field> GET_ORDERABLE_FIELD = new Function<FieldLayoutItem, Field>(){

        public Field apply(FieldLayoutItem fieldLayoutItem) {
            return fieldLayoutItem.getOrderableField();
        }
    };

    public IssueBeanBuilder(FieldLayoutManager fieldLayoutManager, JiraAuthenticationContext authContext, FieldManager fieldManager, ResourceUriBuilder resourceUriBuilder, BeanBuilderFactory beanBuilderFactory, ContextUriInfo contextUriInfo, Issue issue, IncludedFields fieldsToInclude, IssueLinksBeanBuilderFactory issueLinkBeanBuilderFactory, IssueWorkflowManager issueWorkflowManager) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.authContext = authContext;
        this.fieldManager = fieldManager;
        this.resourceUriBuilder = resourceUriBuilder;
        this.beanBuilderFactory = beanBuilderFactory;
        this.contextUriInfo = contextUriInfo;
        this.issue = issue;
        this.fieldsToInclude = fieldsToInclude;
        this.issueLinkBeanBuilderFactory = issueLinkBeanBuilderFactory;
        this.issueWorkflowManager = issueWorkflowManager;
    }

    public IssueBeanBuilder expand(String expand) {
        this.expand = expand;
        return this;
    }

    public IssueBeanBuilder uriBuilder(UriBuilder uriBuilder) {
        this.uriBuilder = uriBuilder;
        return this;
    }

    public IssueBean build() {
        IssueBean bean = new IssueBean(this.issue.getId(), this.issue.getKey(), this.resourceUriBuilder.build(this.uriBuilder == null ? this.contextUriInfo.getBaseUriBuilder() : this.uriBuilder, IssueResource.class, String.valueOf(this.issue.getId())));
        bean.fieldsToInclude(this.fieldsToInclude);
        this.addFields(this.issue, bean);
        this.addParentLink(this.issue, bean);
        this.addTransitions(this.issue, bean);
        this.addOpsbar(this.issue, bean);
        if (this.expand != null && this.expand.contains("editmeta")) {
            EditMetaBean editmeta = this.beanBuilderFactory.newEditMetaBeanBuilder().issue(this.issue).fieldsToInclude(this.fieldsToInclude).build();
            bean.editmeta(editmeta);
        }
        if (this.expand != null && this.expand.contains("changelog")) {
            bean.changelog(this.beanBuilderFactory.newChangelogBeanBuilder().build(this.issue));
        }
        return bean;
    }

    private void addTransitions(Issue issue, IssueBean bean) {
        if (this.isIncludeTransitions()) {
            List sortedAvailableActions = this.issueWorkflowManager.getSortedAvailableActions(issue);
            ArrayList<TransitionBean> transitionBeans = new ArrayList<TransitionBean>();
            for (ActionDescriptor action : sortedAvailableActions) {
                TransitionBean transitionMetaBean = this.beanBuilderFactory.newTransitionMetaBeanBuilder().issue(issue).action(action).build();
                transitionBeans.add(transitionMetaBean);
            }
            bean.setTransitionBeans(transitionBeans);
        }
    }

    private void addOpsbar(Issue issue, IssueBean bean) {
        if (this.isIncludeOpsbar()) {
            OpsbarBeanBuilder opsbarBeanBuilder = this.beanBuilderFactory.newOpsbarBeanBuilder(issue);
            bean.setOperations(opsbarBeanBuilder.build());
        }
    }

    private void addParentLink(Issue issue, IssueBean bean) {
        IssueLinksBeanBuilder builder = this.issueLinkBeanBuilderFactory.newIssueLinksBeanBuilder(issue);
        IssueRefJsonBean parentLink = builder.buildParentLink();
        if (parentLink != null) {
            bean.addParentField(parentLink, this.authContext.getI18nHelper().getText("issue.field.parent"));
        }
    }

    private void addFields(Issue issue, IssueBean bean) {
        boolean includeRenderableFields = this.isIncludeRenderableFields();
        FieldLayout layout = this.fieldLayoutManager.getFieldLayout(issue);
        List fieldLayoutItems = layout.getVisibleLayoutItems(issue.getProjectObject(), CollectionBuilder.list((Object[])new String[]{issue.getIssueTypeObject().getId()}));
        Predicate fieldIncluded = this.fieldsToInclude == null ? Predicates.alwaysTrue() : new Predicate<Field>(){

            public boolean apply(Field field) {
                return IssueBeanBuilder.this.fieldsToInclude.included(field);
            }
        };
        Predicate fieldLayoutItemIncluded = this.fieldsToInclude == null ? Predicates.alwaysTrue() : Predicates.compose((Predicate)fieldIncluded, GET_ORDERABLE_FIELD);
        for (FieldLayoutItem fieldLayoutItem : Iterables.filter((Iterable)fieldLayoutItems, (Predicate)fieldLayoutItemIncluded)) {
            OrderableField field = fieldLayoutItem.getOrderableField();
            FieldJsonRepresentation fieldValue = this.getFieldValue(fieldLayoutItem, issue);
            if (fieldValue == null || fieldValue.getStandardData() == null) continue;
            bean.addField((Field)field, fieldValue, includeRenderableFields);
        }
        try {
            Set fields = this.fieldManager.getAvailableNavigableFields(this.authContext.getLoggedInUser());
            for (OrderableField field : Iterables.filter((Iterable)fields, (Predicate)fieldIncluded)) {
                if (bean.hasField(field.getId()) || field instanceof OrderableField && !this.isSpecialField((NavigableField)field) || !(field instanceof RestAwareField)) continue;
                this.addRestAwareField(issue, bean, (Field)field, (RestAwareField)field);
            }
        }
        catch (FieldException e) {
            // empty catch block
        }
    }

    private boolean isSpecialField(NavigableField field) {
        return field instanceof ProjectSystemField;
    }

    private void addRestAwareField(Issue issue, IssueBean bean, Field field, RestAwareField restAware) {
        boolean includeRenderableFields = this.isIncludeRenderableFields();
        FieldJsonRepresentation fieldJsonFromIssue = restAware.getJsonFromIssue(issue, includeRenderableFields, null);
        if (fieldJsonFromIssue != null && fieldJsonFromIssue.getStandardData() != null) {
            bean.addField(field, fieldJsonFromIssue, includeRenderableFields);
        }
    }

    private boolean isIncludeRenderableFields() {
        return this.expand != null && this.expand.contains("renderedFields");
    }

    private boolean isIncludeTransitions() {
        return this.expand != null && this.expand.contains("transitions");
    }

    private boolean isIncludeOpsbar() {
        return this.expand != null && this.expand.contains("operations");
    }

    FieldJsonRepresentation getFieldValue(FieldLayoutItem fieldLayoutItem, Issue issue) {
        OrderableField field = fieldLayoutItem.getOrderableField();
        if (field instanceof RestAwareField) {
            RestAwareField restAware = (RestAwareField)field;
            try {
                return restAware.getJsonFromIssue(issue, this.isIncludeRenderableFields(), fieldLayoutItem);
            }
            catch (RuntimeException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Cannot get value from RestAwareField %s, exception: '%s' ", field.getId(), e.getMessage()), (Throwable)e);
                } else {
                    LOG.info((Object)String.format("Cannot get value from RestAwareField %s, exception: '%s' ", field.getId(), e.getMessage()));
                }
                return null;
            }
        }
        LOG.info((Object)String.format("OrderableField %s not rendered in JSON", field.getId()));
        return null;
    }
}

