/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueRefJsonBean;
import com.atlassian.jira.rest.api.issue.JsonTypeBean;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.v2.issue.ChangelogBean;
import com.atlassian.jira.rest.v2.issue.EditMetaBean;
import com.atlassian.jira.rest.v2.issue.IncludedFields;
import com.atlassian.jira.rest.v2.issue.OpsbarBean;
import com.atlassian.jira.rest.v2.issue.TransitionBean;
import com.atlassian.plugins.rest.common.expand.Expandable;
import com.atlassian.plugins.rest.common.expand.SelfExpanding;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="issue")
public class IssueBean {
    @XmlAttribute
    private String expand;
    @XmlElement
    private String id;
    @XmlElement
    private URI self;
    @XmlElement
    private String key;
    @XmlElement
    private HashMap<String, Object> fields;
    @XmlElement
    private HashMap<String, Object> renderedFields;
    @XmlTransient
    private HashMap<String, Object> renderedFields_ = Maps.newHashMap();
    @XmlTransient
    @Expandable(value="renderedFields")
    private SelfExpanding renderedFieldExpander = new SelfExpanding(){

        public void expand() {
            IssueBean.this.renderedFields = IssueBean.this.renderedFields_;
        }
    };
    @XmlElement
    private HashMap<String, String> names;
    @XmlTransient
    private HashMap<String, String> names_ = Maps.newHashMap();
    @XmlTransient
    @Expandable(value="names")
    private SelfExpanding namesExpander = new SelfExpanding(){

        public void expand() {
            IssueBean.this.names = IssueBean.this.names_;
        }
    };
    @XmlElement
    private Map<String, JsonTypeBean> schema;
    @XmlTransient
    private final Map<String, JsonTypeBean> schema_ = Maps.newHashMap();
    @XmlTransient
    @Expandable(value="schema")
    private SelfExpanding schemaExpander = new SelfExpanding(){

        public void expand() {
            IssueBean.this.schema = IssueBean.this.schema_;
        }
    };
    @XmlElement
    private List<TransitionBean> transitions;
    @XmlTransient
    private final List<TransitionBean> transitions_ = Lists.newArrayList();
    @XmlTransient
    @Expandable(value="transitions")
    private SelfExpanding transitionExpander = new SelfExpanding(){

        public void expand() {
            IssueBean.this.transitions = IssueBean.this.transitions_;
        }
    };
    @XmlElement
    private OpsbarBean operations;
    @XmlTransient
    private OpsbarBean operations_ = null;
    @XmlTransient
    @Expandable(value="operations")
    private SelfExpanding operationsExpander = new SelfExpanding(){

        public void expand() {
            IssueBean.this.operations = IssueBean.this.operations_;
        }
    };
    @XmlTransient
    @Expandable(value="editmeta")
    private SelfExpanding editmetaExpander = new SelfExpanding(){

        public void expand() {
            IssueBean.this.editmeta = IssueBean.this.editmeta_;
        }
    };
    @XmlElement
    private EditMetaBean editmeta;
    @XmlTransient
    private EditMetaBean editmeta_;
    @XmlTransient
    @Expandable(value="changelog")
    private SelfExpanding changelogExpander = new SelfExpanding(){

        public void expand() {
            IssueBean.this.changelog = IssueBean.this.changelog_;
        }
    };
    @XmlElement
    private ChangelogBean changelog;
    @XmlTransient
    private ChangelogBean changelog_;
    private IncludedFields fieldsToInclude;

    public IssueBean() {
    }

    public IssueBean(Long id, String key, URI selfUri) {
        this(id == null ? null : id.toString(), key, selfUri);
    }

    public IssueBean(String id, String key, URI selfUri) {
        this.id = id;
        this.self = selfUri;
        this.key = key;
    }

    public IssueBean fieldsToInclude(IncludedFields fieldsToInclude) {
        this.fieldsToInclude = fieldsToInclude;
        return this;
    }

    public IssueBean fields(Map<String, Object> fields) {
        this.fields = Maps.newHashMap(fields);
        return this;
    }

    public void addField(Field field, FieldJsonRepresentation data, boolean includeRenderedVersion) {
        JsonType schema = field instanceof RestAwareField ? ((RestAwareField)field).getJsonSchema() : null;
        String fieldId = field.getId();
        if (this.fieldsToInclude == null || this.fieldsToInclude.included(field)) {
            String displayName = field.getName();
            this.addRawField(fieldId, displayName, schema, data.getStandardData().getData());
            if (includeRenderedVersion && data.getRenderedData() != null) {
                this.renderedFields_.put(fieldId, data.getRenderedData().getData());
            }
        }
    }

    public void addParentField(IssueRefJsonBean value, String displayName) {
        String fieldId = "parent";
        JsonType schema = JsonTypeBuilder.systemArray((String)"issuelinks", (String)"parent");
        if (this.fieldsToInclude == null || this.fieldsToInclude.included(fieldId, true)) {
            this.addRawField(fieldId, displayName, schema, value);
        }
    }

    void addRawField(String fieldId, String displayName, JsonType schema, Object value) {
        if (this.fields == null) {
            this.fields = Maps.newHashMap();
        }
        this.names_.put(fieldId, displayName);
        if (schema != null) {
            this.schema_.put(fieldId, new JsonTypeBean(schema.getType(), schema.getItems(), schema.getSystem(), schema.getCustom(), schema.getCustomId()));
        }
        this.fields.put(fieldId, value);
    }

    public boolean hasField(String fieldId) {
        return this.fields != null && this.fields.containsKey(fieldId);
    }

    public String getKey() {
        return this.key;
    }

    public String getId() {
        return this.id;
    }

    public List<String> expand() {
        return StringList.fromQueryParam(this.expand).asList();
    }

    public IssueBean expand(Iterable<String> expand) {
        this.expand = expand != null ? StringList.fromList(expand).toQueryParam() : null;
        return this;
    }

    public Map<String, String> names() {
        return this.names;
    }

    public IssueBean names(@Nullable HashMap<String, String> names) {
        this.names = names;
        return this;
    }

    public Map<String, JsonTypeBean> schema() {
        return this.schema;
    }

    public IssueBean schema(@Nullable Map<String, JsonTypeBean> schema) {
        this.schema = schema;
        return this;
    }

    public IssueBean editmeta(EditMetaBean editmeta) {
        this.editmeta_ = editmeta;
        return this;
    }

    public void setTransitionBeans(List<TransitionBean> transitionBeans) {
        this.transitions_.addAll(transitionBeans);
    }

    public void setOperations(OpsbarBean opsbarBean) {
        this.operations_ = opsbarBean;
    }

    public IssueBean changelog(ChangelogBean changelog) {
        this.changelog_ = changelog;
        return this;
    }
}

