/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.rest.api.util.StringList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IncludedFields {
    private final boolean includeAll;
    private final boolean includeNavigable;
    private final Set<String> include = new HashSet<String>();
    private final Set<String> exclude = new HashSet<String>();

    IncludedFields(boolean includeAllByDefault, boolean includeNavigableByDefault, List<StringList> fields) {
        boolean includeAll = false;
        boolean includeNavigable = false;
        if (fields != null) {
            for (String id : StringList.joinLists(fields).asList()) {
                if ("*all".equals(id)) {
                    includeAllByDefault = true;
                    includeAll = true;
                    includeNavigable = true;
                    continue;
                }
                if ("*navigable".equals(id)) {
                    includeAllByDefault = false;
                    includeNavigableByDefault = true;
                    includeNavigable = true;
                    continue;
                }
                if (id.startsWith("-")) {
                    id = id.substring(1);
                    this.exclude.add(id);
                    continue;
                }
                this.include.add(id);
            }
        }
        if (this.include.isEmpty()) {
            this.includeAll = includeAllByDefault;
            this.includeNavigable = includeNavigableByDefault;
        } else {
            this.includeAll = includeAll;
            this.includeNavigable = includeNavigable;
        }
    }

    public static IncludedFields includeAllByDefault(List<StringList> fields) {
        return new IncludedFields(true, true, fields);
    }

    public static IncludedFields includeNavigableByDefault(List<StringList> fields) {
        return new IncludedFields(false, true, fields);
    }

    public boolean included(Field field) {
        return this.included(field.getId(), field instanceof NavigableField);
    }

    public boolean included(String fieldId, boolean navigable) {
        if (this.exclude.contains(fieldId)) {
            return false;
        }
        if (this.includeAll || navigable && this.includeNavigable) {
            return true;
        }
        return this.include.contains(fieldId);
    }
}

