/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.group.GroupService;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.exception.BadRequestWebException;
import com.atlassian.jira.rest.exception.ForbiddenWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.exception.ServerErrorWebException;
import com.atlassian.jira.rest.util.ResponseUtils;
import com.atlassian.jira.rest.v2.issue.AddGroupBean;
import com.atlassian.jira.rest.v2.issue.GroupBean;
import com.atlassian.jira.rest.v2.issue.GroupBeanBuilder;
import com.atlassian.jira.rest.v2.issue.UpdateUserToGroupBean;
import com.atlassian.jira.rest.v2.issue.UserJsonBeanListWrapper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="group")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class GroupResource {
    static final int MAX_EXPANDED_USERS_COUNT = 50;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authContext;
    private final I18nHelper i18n;
    private final GroupManager groupManager;
    private final GroupService groupService;
    private final JiraBaseUrls jiraBaseUrls;
    private final CrowdService crowdService;
    private final Predicate<User> UserIsActivePredicate = new Predicate<User>(){

        public boolean apply(@Nullable User user) {
            return user != null && user.isActive();
        }
    };

    public GroupResource(PermissionManager permissionManager, JiraAuthenticationContext authContext, I18nHelper i18n, GroupManager groupManager, GroupService groupService, JiraBaseUrls jiraBaseUrls, CrowdService crowdService) {
        this.permissionManager = permissionManager;
        this.authContext = authContext;
        this.i18n = i18n;
        this.groupManager = groupManager;
        this.groupService = groupService;
        this.jiraBaseUrls = jiraBaseUrls;
        this.crowdService = crowdService;
    }

    @GET
    public Response getGroup(@QueryParam(value="groupname") String groupName, @QueryParam(value="expand") StringList expand) {
        ApplicationUser remoteUser = this.authContext.getUser();
        if (!this.permissionManager.hasPermission(0, remoteUser) && !this.permissionManager.hasPermission(44, remoteUser)) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("rest.group.not.authorised")));
        }
        this.validateGroupName(groupName);
        Group group = this.groupManager.getGroup(groupName.trim());
        if (group == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.group.error.not.found", groupName)));
        }
        GroupBean groupBean = this.buildGroupBean(group);
        return Response.ok((Object)((Object)groupBean)).build();
    }

    @POST
    @WebSudoRequired
    @ExperimentalApi
    public Response createGroup(AddGroupBean groupBean) {
        final String groupName = groupBean.getName();
        Response response = this.doGroupUpdate(new GroupUpdateCommand(groupName){

            @Override
            public Response execute() throws OperationNotPermittedException, InvalidGroupException {
                GroupResource.this.validateGroupName(groupName);
                if (GroupResource.this.crowdService.getGroup(groupName) != null) {
                    throw new BadRequestWebException(ErrorCollection.of(GroupResource.this.i18n.getText("groupbrowser.error.group.exists")));
                }
                ImmutableGroup immutableGroup = new ImmutableGroup(groupName);
                GroupResource.this.crowdService.addGroup((Group)immutableGroup);
                GroupBean responseGroupBean = GroupResource.this.buildGroupBean((Group)immutableGroup);
                return Response.status((Response.Status)Response.Status.CREATED).location(responseGroupBean.getSelf()).entity((Object)responseGroupBean).cacheControl(CacheControl.never()).build();
            }
        });
        return response;
    }

    @DELETE
    @WebSudoRequired
    @ExperimentalApi
    public Response removeGroup(final @QueryParam(value="groupname") String groupName, final @QueryParam(value="swapGroup") String swapGroup) {
        Response response = this.doGroupUpdate(new GroupUpdateCommand(groupName){

            @Override
            public Response execute() throws OperationNotPermittedException {
                GroupResource.this.ensureGroupExists(groupName);
                JiraServiceContextImpl validateContext = new JiraServiceContextImpl(GroupResource.this.authContext.getUser());
                if (!GroupResource.this.groupService.validateDelete((JiraServiceContext)validateContext, groupName, swapGroup)) {
                    return ResponseUtils.throwEx(validateContext.getErrorCollection());
                }
                JiraServiceContextImpl deleteContext = new JiraServiceContextImpl(GroupResource.this.authContext.getUser());
                if (!GroupResource.this.groupService.delete((JiraServiceContext)deleteContext, groupName, swapGroup)) {
                    return ResponseUtils.throwEx(deleteContext.getErrorCollection());
                }
                return Response.ok().cacheControl(CacheControl.never()).build();
            }
        });
        return response;
    }

    @POST
    @WebSudoRequired
    @ExperimentalApi
    @Path(value="user")
    public Response addUserToGroup(final @QueryParam(value="groupname") String groupName, final UpdateUserToGroupBean userBean) {
        Response response = this.doGroupUpdate(new GroupUpdateCommand(groupName){

            @Override
            public Response execute() throws OperationNotPermittedException {
                GroupResource.this.ensureGroupExists(groupName);
                String username = userBean.getName();
                JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(GroupResource.this.authContext.getUser());
                if (!GroupResource.this.groupService.validateAddUserToGroup((JiraServiceContext)serviceContext, (Collection)ImmutableList.of((Object)groupName), username)) {
                    return ResponseUtils.throwEx(serviceContext.getErrorCollection());
                }
                User crowdUser = GroupResource.this.getUser(username);
                ImmutableGroup immutableGroup = new ImmutableGroup(groupName);
                User immutableUser = ImmutableUser.newUser((User)crowdUser).toUser();
                if (GroupResource.this.crowdService.addUserToGroup(immutableUser, (Group)immutableGroup)) {
                    GroupBean responseGroupBean = GroupResource.this.buildGroupBean((Group)immutableGroup);
                    return Response.status((Response.Status)Response.Status.CREATED).location(responseGroupBean.getSelf()).entity((Object)responseGroupBean).cacheControl(CacheControl.never()).build();
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)GroupResource.this.i18n.getText("rest.group.user.already.exists.in.group", username, groupName)).cacheControl(CacheControl.never()).build();
            }
        });
        return response;
    }

    @WebSudoRequired
    @ExperimentalApi
    @DELETE
    @Path(value="user")
    public Response removeUserFromGroup(final @QueryParam(value="groupname") String groupName, final @QueryParam(value="username") String username) {
        Response response = this.doGroupUpdate(new GroupUpdateCommand(groupName){

            @Override
            public Response execute() throws OperationNotPermittedException {
                GroupResource.this.ensureGroupExists(groupName);
                User crowdUser = GroupResource.this.getUser(username);
                JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(GroupResource.this.authContext.getUser());
                if (!GroupResource.this.groupService.validateRemoveUserFromGroups((JiraServiceContext)serviceContext, (List)ImmutableList.of((Object)groupName), username)) {
                    return ResponseUtils.throwEx(serviceContext.getErrorCollection());
                }
                ImmutableGroup immutableGroup = new ImmutableGroup(groupName);
                User immutableUser = ImmutableUser.newUser((User)crowdUser).toUser();
                GroupResource.this.crowdService.removeUserFromGroup(immutableUser, (Group)immutableGroup);
                return Response.ok().cacheControl(CacheControl.never()).build();
            }
        });
        return response;
    }

    private Response doGroupUpdate(GroupUpdateCommand command) {
        this.ensureCanManageGroups();
        String groupName = command.getGroupName();
        try {
            return command.execute();
        }
        catch (OperationNotPermittedException e) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("generic.error", e.getLocalizedMessage())));
        }
        catch (InvalidGroupException e) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("generic.error", e.getLocalizedMessage())));
        }
        catch (OperationFailedException e) {
            throw new ServerErrorWebException(ErrorCollection.of(this.i18n.getText("generic.error", e.getLocalizedMessage())));
        }
    }

    private void ensureGroupExists(String groupName) {
        this.validateGroupName(groupName);
        Group crowdGroup = this.crowdService.getGroup(groupName);
        if (crowdGroup == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.group.error.not.found", groupName)));
        }
    }

    private User getUser(String username) {
        User crowdUser = null;
        if (username != null && (crowdUser = this.crowdService.getUser(username)) == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("admin.errors.user.does.not.exist", username)));
        }
        return crowdUser;
    }

    private void ensureCanManageGroups() {
        ApplicationUser remoteUser = this.authContext.getUser();
        if (!this.permissionManager.hasPermission(0, remoteUser) && !this.permissionManager.hasPermission(44, remoteUser)) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("rest.group.not.authorised")));
        }
    }

    private void validateGroupName(String groupName) {
        if (StringUtils.isEmpty((String)groupName)) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("rest.group.error.empty")));
        }
    }

    private GroupBean buildGroupBean(Group group) {
        ImmutableList usersInGroup = ImmutableList.copyOf((Collection)Collections2.filter((Collection)this.groupManager.getUsersInGroup(group), this.UserIsActivePredicate));
        UserJsonBeanListWrapper userJsonBeanListWrapper = new UserJsonBeanListWrapper(this.jiraBaseUrls, (List<User>)usersInGroup, 50);
        return new GroupBeanBuilder(this.jiraBaseUrls, group.getName()).users(userJsonBeanListWrapper).build();
    }

    private static class GroupUpdateCommand {
        private final String groupName;

        private GroupUpdateCommand(String groupName) {
            this.groupName = groupName;
        }

        private String getGroupName() {
            return this.groupName;
        }

        Response execute() throws OperationNotPermittedException, InvalidGroupException {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

