/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.customfield.CreateValidationResult;
import com.atlassian.jira.bc.customfield.CustomFieldDefinition;
import com.atlassian.jira.bc.customfield.CustomFieldService;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.rest.api.customfield.CustomFieldDefinitionJsonBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.issue.FieldBean;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

@Path(value="field")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class FieldResource {
    private static final Logger LOG = Logger.getLogger(FieldResource.class);
    private final FieldManager fieldManager;
    private final JiraAuthenticationContext authenticationContext;
    private final CustomFieldService customFieldService;
    private final SearchHandlerManager searchHandlerManager;

    public FieldResource(FieldManager fieldManager, JiraAuthenticationContext authenticationContext, CustomFieldService customFieldService, SearchHandlerManager searchHandlerManager) {
        this.fieldManager = fieldManager;
        this.authenticationContext = authenticationContext;
        this.customFieldService = customFieldService;
        this.searchHandlerManager = searchHandlerManager;
    }

    @GET
    public Response getFields() {
        HashSet<Field> fields = new HashSet<Field>();
        Set orderableFields = this.fieldManager.getOrderableFields();
        for (OrderableField orderableField : orderableFields) {
            if (orderableField instanceof NavigableField) continue;
            fields.add((Field)orderableField);
        }
        try {
            fields.addAll(this.fieldManager.getAvailableNavigableFields(this.authenticationContext.getLoggedInUser()));
        }
        catch (FieldException e) {
            throw new RESTException(Response.Status.INTERNAL_SERVER_ERROR, e.getLocalizedMessage());
        }
        return Response.ok(FieldBean.shortBeans(fields, this.fieldManager, this.searchHandlerManager)).build();
    }

    @POST
    public Response createCustomField(CustomFieldDefinitionJsonBean customFieldDefinitionJsonBean) {
        CustomFieldDefinition customFieldDefinition = CustomFieldDefinition.builder().name(customFieldDefinitionJsonBean.name()).description(customFieldDefinitionJsonBean.description()).cfType(customFieldDefinitionJsonBean.type()).searcherKey(customFieldDefinitionJsonBean.searcherKey()).isGlobal(true).isAllIssueTypes(true).build();
        ServiceOutcome outcome = this.customFieldService.validateCreate(this.authenticationContext.getLoggedInUser(), customFieldDefinition);
        if (!outcome.isValid()) {
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(outcome.getErrorCollection()));
        }
        ServiceOutcome serviceOutcome = this.customFieldService.create((CreateValidationResult)outcome.getReturnedValue());
        Field field = this.fieldManager.getField(((CustomField)serviceOutcome.getReturnedValue()).getId());
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)FieldBean.shortBean(field, this.fieldManager, this.searchHandlerManager)).build();
    }
}

