/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;

public class Examples {
    public static final String JIRA_BASE_URL = "http://www.example.com/jira";
    public static final String REST_BASE_URL = "http://www.example.com/jira/rest/api/2";

    public static URI jiraURI(String ... pathSegments) {
        return Examples.createURI(JIRA_BASE_URL, pathSegments);
    }

    public static URI restURI(String ... pathSegments) {
        String base = REST_BASE_URL;
        return Examples.createURI(base, pathSegments);
    }

    private static URI createURI(String base, String[] pathSegments) {
        String path = String.format("%s/%s", base, pathSegments != null ? StringUtils.join((Object[])pathSegments, (char)'/') : "");
        try {
            return new URI(path);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error parsing URI: " + path, e);
        }
    }

    private Examples() {
    }
}

