/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.v2.issue.AbstractMetaFieldBeanBuilder;
import com.atlassian.jira.rest.v2.issue.EditIssueOperationContext;
import com.atlassian.jira.rest.v2.issue.FieldMetaBean;
import com.atlassian.jira.rest.v2.issue.context.ContextUriInfo;
import com.atlassian.jira.rest.v2.issue.version.VersionBeanFactory;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import java.util.Map;

public class EditMetaFieldBeanBuilder
extends AbstractMetaFieldBeanBuilder {
    private final OperationContext operationContext = new EditIssueOperationContext();
    private final PermissionManager permissionManager;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final FieldManager fieldManager;

    public EditMetaFieldBeanBuilder(FieldLayoutManager fieldLayoutManager, Project project, Issue issue, IssueType issueType, User user, VersionBeanFactory versionBeanFactory, VelocityRequestContextFactory velocityRequestContextFactory, ContextUriInfo contextUriInfo, JiraBaseUrls baseUrls, PermissionManager permissionManager, FieldScreenRendererFactory fieldScreenRendererFactory, FieldManager fieldManager) {
        super(fieldLayoutManager, project, issue, issueType, user, versionBeanFactory, velocityRequestContextFactory, contextUriInfo, baseUrls, null);
        this.permissionManager = permissionManager;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.fieldManager = fieldManager;
    }

    @Override
    protected void addAdditionalFields(Map<String, FieldMetaBean> fields) {
        OrderableField field = (OrderableField)this.fieldManager.getField(SystemSearchConstants.forComments().getFieldId());
        if (field.isShown(this.issue)) {
            String id = field.getId();
            if (this.includeFields == null || this.includeFields.included((Field)field)) {
                FieldMetaBean fieldMetaBean = this.getFieldMetaBean(false, field);
                fields.put(id, fieldMetaBean);
            }
        }
    }

    @Override
    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    @Override
    public boolean hasPermissionToPerformOperation() {
        return this.permissionManager.hasPermission(12, this.issue, this.user);
    }

    @Override
    FieldScreenRenderer getFieldScreenRenderer(Issue issue) {
        return this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, (IssueOperation)IssueOperations.EDIT_ISSUE_OPERATION);
    }
}

