/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

public class DeleteIssueResource {
    private final IssueService issueService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final SubTaskManager subTaskManager;

    public DeleteIssueResource(JiraAuthenticationContext jiraAuthenticationContext, IssueService issueService, SubTaskManager subTaskManager) {
        this.issueService = issueService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.subTaskManager = subTaskManager;
    }

    public Response deleteIssue(Issue issue, String deleteSubtasks, @Context UriInfo uriInfo) {
        IssueService.DeleteValidationResult issueValidationResult = this.issueService.validateDelete(this.callingUser(), issue.getId());
        if (!issueValidationResult.isValid()) {
            throw this.error(ErrorCollection.of(issueValidationResult.getErrorCollection()));
        }
        if (!Boolean.valueOf(deleteSubtasks).booleanValue() && this.getNumberOfSubTasks(issue) > 0) {
            throw this.error(ErrorCollection.of(this.jiraAuthenticationContext.getI18nHelper().getText("rest.issue.delete.subtasks.present", issue.getKey())).reason(ErrorCollection.Reason.VALIDATION_FAILED));
        }
        com.atlassian.jira.util.ErrorCollection errors = this.issueService.delete(this.callingUser(), issueValidationResult);
        if (errors.hasAnyErrors()) {
            throw this.error(ErrorCollection.of(errors));
        }
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    protected WebApplicationException error(ErrorCollection errors) {
        return new WebApplicationException(Response.status((int)errors.getStatus()).entity((Object)errors).cacheControl(CacheControl.never()).build());
    }

    protected User callingUser() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }

    public int getNumberOfSubTasks(Issue issue) {
        return this.subTaskManager.getSubTaskIssueLinks(issue.getLong("id")).size();
    }
}

