/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.event.user.UserProfileUpdatedEvent;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.plugin.user.PasswordPolicyManager;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.BadRequestWebException;
import com.atlassian.jira.rest.exception.ForbiddenWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.v2.issue.PasswordBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.rest.v2.issue.UserWriteBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.ImmutableList;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="myself")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ExperimentalApi
public class CurrentUserResource {
    private static final int MAX_LENGTH = 255;
    private final UserService userService;
    private final UserUtil userUtil;
    private final UserManager userManager;
    private final PasswordPolicyManager passwordPolicyManager;
    private final EventPublisher eventPublisher;
    private final I18nHelper i18n;
    private final EmailFormatter emailFormatter;
    private final JiraAuthenticationContext authContext;
    private final TimeZoneManager timeZoneManager;
    private final AvatarService avatarService;
    private final JiraBaseUrls jiraBaseUrls;

    public CurrentUserResource(UserService userService, UserUtil userUtil, UserManager userManager, PasswordPolicyManager passwordPolicyManager, EventPublisher eventPublisher, I18nHelper i18n, EmailFormatter emailFormatter, JiraAuthenticationContext authContext, TimeZoneManager timeZoneManager, AvatarService avatarService, JiraBaseUrls jiraBaseUrls) {
        this.userService = userService;
        this.userManager = userManager;
        this.passwordPolicyManager = passwordPolicyManager;
        this.eventPublisher = eventPublisher;
        this.jiraBaseUrls = jiraBaseUrls;
        this.userUtil = userUtil;
        this.i18n = i18n;
        this.emailFormatter = emailFormatter;
        this.authContext = authContext;
        this.timeZoneManager = timeZoneManager;
        this.avatarService = avatarService;
    }

    @GET
    public Response getUser() {
        ApplicationUser currentUser = this.authContext.getUser();
        if (currentUser == null) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("error.no-permission")));
        }
        return this.createUserResponse(currentUser);
    }

    @PUT
    public Response updateUser(UserWriteBean userBean) {
        ApplicationUser currentUser = this.authContext.getUser();
        if (currentUser == null) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("error.no-permission")));
        }
        if (StringUtils.isBlank((CharSequence)userBean.getEmailAddress()) && StringUtils.isBlank((CharSequence)userBean.getDisplayName())) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("error.no.value.found.to.be.changed")));
        }
        if (StringUtils.length((CharSequence)userBean.getDisplayName()) > 255) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("error.display.name.too.long")));
        }
        if (StringUtils.length((CharSequence)userBean.getEmailAddress()) > 255) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("error.email.address.too.long")));
        }
        if (StringUtils.isNotBlank((CharSequence)userBean.getEmailAddress()) && !TextUtils.verifyEmail((String)userBean.getEmailAddress())) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("error.invalid.email.address.format")));
        }
        if (!this.userManager.canUpdateUser(currentUser)) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("error.cannot.edit.user.directory.read.only")));
        }
        ImmutableUser.Builder userBuilder = ImmutableUser.newUser((User)currentUser.getDirectoryUser());
        userBuilder.emailAddress((String)StringUtils.defaultIfBlank((CharSequence)userBean.getEmailAddress(), (CharSequence)currentUser.getEmailAddress()));
        userBuilder.displayName((String)StringUtils.defaultIfBlank((CharSequence)userBean.getDisplayName(), (CharSequence)currentUser.getDisplayName()));
        this.userManager.updateUser(userBuilder.toUser());
        String key = currentUser.getKey();
        ApplicationUser changedUser = this.userUtil.getUserByKey(key);
        if (changedUser == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("error-no-entity")));
        }
        this.eventPublisher.publish((Object)new UserProfileUpdatedEvent(changedUser.getDirectoryUser(), changedUser.getDirectoryUser()));
        return this.createUserResponse(changedUser);
    }

    @PUT
    @Path(value="password")
    public Response changeMyPassword(PasswordBean passwordBean) {
        ApplicationUser currentUser = this.authContext.getUser();
        if (currentUser == null) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("error.no-permission")));
        }
        String password = passwordBean.getPassword();
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("error.password.cannot.be.empty")));
        }
        Collection messages = this.passwordPolicyManager.checkPolicy(currentUser, null, password);
        if (!messages.isEmpty()) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("changepassword.new.password.rejected")));
        }
        try {
            this.userUtil.changePassword(currentUser.getDirectoryUser(), password);
        }
        catch (UserNotFoundException e) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("error-no-entity")));
        }
        catch (InvalidCredentialException e) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("error.no-permission")));
        }
        catch (OperationNotPermittedException e) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("error.no-permission")));
        }
        catch (PermissionException e) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("error.no-permission")));
        }
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    private Response createUserResponse(ApplicationUser currentUser) {
        UserBeanBuilder builder = new UserBeanBuilder(this.jiraBaseUrls).user(currentUser).groups((List<String>)ImmutableList.copyOf((Collection)this.userUtil.getGroupNamesForUser(currentUser.getUsername()))).loggedInUser(currentUser).emailFormatter(this.emailFormatter).timeZone(this.timeZoneManager.getTimeZoneforUser(currentUser.getDirectoryUser())).avatarService(this.avatarService);
        return Response.ok((Object)builder.buildFull()).cacheControl(CacheControl.never()).build();
    }
}

