/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.ProjectSystemField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.ProjectJsonBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.v2.issue.AbstractMetaFieldBeanBuilder;
import com.atlassian.jira.rest.v2.issue.CreateIssueOperationContext;
import com.atlassian.jira.rest.v2.issue.DefaultFieldMetaBeanHelper;
import com.atlassian.jira.rest.v2.issue.FieldMetaBean;
import com.atlassian.jira.rest.v2.issue.context.ContextUriInfo;
import com.atlassian.jira.rest.v2.issue.version.VersionBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import java.util.Collections;
import java.util.Map;

public class CreateMetaFieldBeanBuilder
extends AbstractMetaFieldBeanBuilder {
    private final OperationContext operationContext = new CreateIssueOperationContext();
    private final PermissionManager permissionManager;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final JiraAuthenticationContext authContext;
    private final FieldManager fieldManager;

    public CreateMetaFieldBeanBuilder(FieldLayoutManager fieldLayoutManager, Project project, Issue issue, IssueType issueType, User user, VersionBeanFactory versionBeanFactory, VelocityRequestContextFactory velocityRequestContextFactory, ContextUriInfo contextUriInfo, JiraBaseUrls baseUrls, PermissionManager permissionManager, FieldScreenRendererFactory fieldScreenRendererFactory, JiraAuthenticationContext authContext, FieldManager fieldManager, DefaultFieldMetaBeanHelper defaultFieldHelper) {
        super(fieldLayoutManager, project, issue, issueType, user, versionBeanFactory, velocityRequestContextFactory, contextUriInfo, baseUrls, defaultFieldHelper);
        this.permissionManager = permissionManager;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.authContext = authContext;
        this.fieldManager = fieldManager;
    }

    @Override
    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    @Override
    public Map<String, FieldMetaBean> build() {
        Map<String, FieldMetaBean> fields = super.build();
        fields.put("project", this.createProjectFieldMetaBean());
        if (!fields.containsKey("issuetype")) {
            fields.put("issuetype", this.createIssueTypeFieldMetaBean());
        }
        if (this.issueType.isSubTask()) {
            fields.put("parent", this.createParentFieldMetaBean());
        }
        return fields;
    }

    private FieldMetaBean createParentFieldMetaBean() {
        return new FieldMetaBean(true, false, JsonTypeBuilder.system((String)"issuelink", (String)"parent"), this.authContext.getI18nHelper().getText("issue.field.parent"), null, Collections.singletonList(StandardOperation.SET.getName()), null);
    }

    private FieldMetaBean createIssueTypeFieldMetaBean() {
        return this.getFieldMetaBean(true, this.fieldManager.getOrderableField("issuetype"));
    }

    private FieldMetaBean createProjectFieldMetaBean() {
        return new FieldMetaBean(true, false, ProjectSystemField.getJsonType(), this.authContext.getI18nHelper().getText("issue.field.project"), null, Collections.singletonList(StandardOperation.SET.getName()), Collections.singletonList(ProjectJsonBean.shortBean((Project)this.project, (JiraBaseUrls)this.baseUrls)));
    }

    @Override
    public boolean hasPermissionToPerformOperation() {
        return this.permissionManager.hasPermission(11, this.issue, this.user);
    }

    @Override
    FieldScreenRenderer getFieldScreenRenderer(Issue issue) {
        return this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, (IssueOperation)IssueOperations.CREATE_ISSUE_OPERATION);
    }
}

