/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.ProjectJsonBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.v2.issue.CreateMetaBean;
import com.atlassian.jira.rest.v2.issue.CreateMetaFieldBeanBuilder;
import com.atlassian.jira.rest.v2.issue.CreateMetaIssueTypeBean;
import com.atlassian.jira.rest.v2.issue.CreateMetaProjectBean;
import com.atlassian.jira.rest.v2.issue.DefaultFieldMetaBeanHelper;
import com.atlassian.jira.rest.v2.issue.IssueTypeBeanBuilder;
import com.atlassian.jira.rest.v2.issue.context.ContextUriInfo;
import com.atlassian.jira.rest.v2.issue.version.VersionBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CreateMetaBeanBuilder {
    private final JiraAuthenticationContext authContext;
    private final ProjectManager projectManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final ContextUriInfo contextUriInfo;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final PermissionManager permissionManager;
    private final VersionBeanFactory versionBeanFactory;
    private final JiraBaseUrls baseUrls;
    private List<StringList> projectIds;
    private List<StringList> projectKeys;
    private List<StringList> issueTypeIds;
    private List<String> issueTypeNames;
    private IssueFactory issueFactory;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final FieldManager fieldManager;
    private final IssueSecurityLevelManager issueSecurityLevelManager;

    public CreateMetaBeanBuilder(JiraAuthenticationContext authContext, ProjectManager projectManager, FieldLayoutManager fieldLayoutManager, VelocityRequestContextFactory velocityRequestContextFactory, ContextUriInfo contextUriInfo, IssueTypeSchemeManager issueTypeSchemeManager, PermissionManager permissionManager, VersionBeanFactory versionBeanFactory, JiraBaseUrls baseUrls, IssueFactory issueFactory, FieldScreenRendererFactory fieldScreenRendererFactory, FieldManager fieldManager, IssueSecurityLevelManager issueSecurityLevelManager) {
        this.authContext = authContext;
        this.projectManager = projectManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.contextUriInfo = contextUriInfo;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.permissionManager = permissionManager;
        this.versionBeanFactory = versionBeanFactory;
        this.baseUrls = baseUrls;
        this.issueFactory = issueFactory;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.fieldManager = fieldManager;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
    }

    private static <T> List<T> mapNullToEmptyList(List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    public CreateMetaBeanBuilder projectIds(List<StringList> projectIds) {
        this.projectIds = CreateMetaBeanBuilder.mapNullToEmptyList(projectIds);
        return this;
    }

    public CreateMetaBeanBuilder projectKeys(List<StringList> projectKeys) {
        this.projectKeys = CreateMetaBeanBuilder.mapNullToEmptyList(projectKeys);
        return this;
    }

    public CreateMetaBeanBuilder issueTypeIds(List<StringList> issueTypeIds) {
        this.issueTypeIds = CreateMetaBeanBuilder.mapNullToEmptyList(issueTypeIds);
        return this;
    }

    public CreateMetaBeanBuilder issueTypeNames(List<String> issueTypeNames) {
        this.issueTypeNames = CreateMetaBeanBuilder.mapNullToEmptyList(issueTypeNames);
        return this;
    }

    public CreateMetaBean build() {
        Iterable<Project> projects = this.getProjects(this.projectIds, this.projectKeys);
        Predicate<IssueType> issueTypes = this.makeIssueTypesPredicate(this.issueTypeIds, this.issueTypeNames);
        ArrayList<CreateMetaProjectBean> projectBeans = new ArrayList<CreateMetaProjectBean>();
        for (Project project : projects) {
            projectBeans.add(this.createProjectBean(project, issueTypes));
        }
        return new CreateMetaBean(projectBeans);
    }

    private CreateMetaProjectBean createProjectBean(Project project, Predicate<IssueType> includeIssueType) {
        List<IssueType> issueTypesForProject = this.getIssueTypesForProject(project, includeIssueType);
        ArrayList<CreateMetaIssueTypeBean> issueTypeBeans = new ArrayList<CreateMetaIssueTypeBean>(issueTypesForProject.size());
        for (IssueType issueType : issueTypesForProject) {
            issueTypeBeans.add(this.createIssueTypeBean(project, issueType));
        }
        ProjectJsonBean projectBean = ProjectJsonBean.shortBean((Project)project, (JiraBaseUrls)this.baseUrls);
        return new CreateMetaProjectBean(projectBean.getSelf(), projectBean.getId(), projectBean.getKey(), projectBean.getName(), projectBean.getAvatarUrls(), issueTypeBeans);
    }

    private List<IssueType> getIssueTypesForProject(Project project, Predicate<IssueType> includeIssueType) {
        Collection allIssueTypesForProject = this.issueTypeSchemeManager.getIssueTypesForProject(project);
        ArrayList<IssueType> result = new ArrayList<IssueType>(allIssueTypesForProject.size());
        for (IssueType issueType : allIssueTypesForProject) {
            if (!includeIssueType.apply((Object)issueType)) continue;
            result.add(issueType);
        }
        return result;
    }

    private CreateMetaIssueTypeBean createIssueTypeBean(Project project, IssueType issueType) {
        IssueTypeJsonBean issueTypeBean = new IssueTypeBeanBuilder().jiraBaseUrls(this.baseUrls).context(this.contextUriInfo).issueType(issueType).build();
        MutableIssue nullIssue = this.issueFactory.getIssue();
        nullIssue.setProjectObject(project);
        nullIssue.setIssueTypeObject(issueType);
        CreateMetaFieldBeanBuilder fieldsBuilder = new CreateMetaFieldBeanBuilder(this.fieldLayoutManager, project, (Issue)nullIssue, issueType, this.authContext.getLoggedInUser(), this.versionBeanFactory, this.velocityRequestContextFactory, this.contextUriInfo, this.baseUrls, this.permissionManager, this.fieldScreenRendererFactory, this.authContext, this.fieldManager, new DefaultFieldMetaBeanHelper(project, issueType, this.issueSecurityLevelManager));
        return new CreateMetaIssueTypeBean(issueTypeBean.getSelf(), issueTypeBean.getId(), issueTypeBean.getName(), issueTypeBean.getDescription(), issueTypeBean.isSubtask(), issueTypeBean.getIconUrl(), fieldsBuilder);
    }

    private Iterable<Project> getProjects(List<StringList> projectIds, List<StringList> projectKeys) {
        if (projectIds.isEmpty() && projectKeys.isEmpty()) {
            return this.getAllProjects();
        }
        LinkedHashMap<Long, Project> projects = new LinkedHashMap<Long, Project>();
        this.addProjectsById((List<String>)StringList.joinLists(projectIds).asList(), (Map<Long, Project>)projects);
        this.addProjectsByKey((List<String>)StringList.joinLists(projectKeys).asList(), (Map<Long, Project>)projects);
        return projects.values();
    }

    private boolean hasCreatePerm(Project project) {
        return this.permissionManager.hasPermission(11, project, this.authContext.getLoggedInUser());
    }

    private List<Project> getAllProjects() {
        return new ArrayList<Project>(this.permissionManager.getProjectObjects(11, this.authContext.getLoggedInUser()));
    }

    private void addProjectsById(List<String> projectIds, Map<Long, Project> projects) {
        for (String projectId : projectIds) {
            Long projectIdLong;
            try {
                projectIdLong = Long.parseLong(projectId);
            }
            catch (NumberFormatException e) {
                continue;
            }
            Project project = this.projectManager.getProjectObj(projectIdLong);
            if (project == null || !this.hasCreatePerm(project) || projects.containsKey(project.getId())) continue;
            projects.put(project.getId(), project);
        }
    }

    private void addProjectsByKey(List<String> projectKeys, Map<Long, Project> projects) {
        for (String projectKey : projectKeys) {
            Project project = this.projectManager.getProjectObjByKey(projectKey);
            if (project == null || !this.hasCreatePerm(project) || projects.containsKey(project.getId())) continue;
            projects.put(project.getId(), project);
        }
    }

    private Predicate<IssueType> makeIssueTypesPredicate(List<StringList> issueTypeIdsList, List<String> issueTypeNames) {
        final HashSet<String> issueTypeIds = new HashSet<String>((Collection<String>)StringList.joinLists(issueTypeIdsList).asList());
        final HashSet<String> issueTypeNameSet = new HashSet<String>(issueTypeNames);
        return new Predicate<IssueType>(){

            public boolean apply(IssueType input) {
                return issueTypeIds.isEmpty() && issueTypeNameSet.isEmpty() || issueTypeIds.contains(input.getId()) || issueTypeNameSet.contains(input.getName());
            }
        };
    }
}

