/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.issue.BulkOperationErrorResult;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssuesCreateResponse;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.issue.IssueInputParametersAssembler;
import com.atlassian.jira.rest.v2.issue.IssueResource;
import com.atlassian.jira.rest.v2.issue.IssueUpdateBean;
import com.atlassian.jira.rest.v2.issue.IssuesUpdateBean;
import com.atlassian.jira.rest.v2.issue.ResourceUriBuilder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

public class CreateIssueResource {
    private final IssueService issueService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ResourceUriBuilder resourceUriBuilder;
    private final SubTaskManager subTaskManager;
    private final IssueInputParametersAssembler issueInputParametersAssembler;

    public CreateIssueResource(JiraAuthenticationContext jiraAuthenticationContext, IssueService issueService, ResourceUriBuilder resourceUriBuilder, SubTaskManager subTaskManager, IssueInputParametersAssembler issueInputParametersAssembler) {
        this.issueService = issueService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.resourceUriBuilder = resourceUriBuilder;
        this.subTaskManager = subTaskManager;
        this.issueInputParametersAssembler = issueInputParametersAssembler;
    }

    public Response createIssue(IssueUpdateBean createRequest, @Context UriInfo uriInfo) {
        IssueInputParametersAssembler.Result result = this.issueInputParametersAssembler.makeCreateAssembler(createRequest);
        if (result.getErrors().hasAnyErrors()) {
            throw this.error(ErrorCollection.of(result.getErrors()));
        }
        IssueInputParameters parameters = result.getParameters();
        MutableIssue issue = result.getParentIdorKey() == null ? this.createIssue(parameters) : this.createSubtask(parameters, result.getParentIdorKey());
        IssueCreateResponse response = new IssueCreateResponse().id(issue.getId().toString()).key(issue.getKey()).self(this.resourceUriBuilder.build(uriInfo, IssueResource.class, String.valueOf(issue.getId())).toString());
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)response).build();
    }

    public Response createIssues(IssuesUpdateBean createRequests, @Context UriInfo uriInfo) {
        if (createRequests.getIssueUpdates() == null || createRequests.getIssueUpdates().isEmpty()) {
            ErrorCollection errorCollection = ErrorCollection.of(this.jiraAuthenticationContext.getI18nHelper().getText("rest.must.provide.issue.data"));
            throw this.error(Response.Status.BAD_REQUEST, errorCollection);
        }
        List<IssueInputParametersAssembler.Result> createAssemblerResults = this.issueInputParametersAssembler.makeCreateAssemblers(createRequests);
        ArrayList errorCollections = Lists.newArrayList();
        ArrayList createdIssues = Lists.newArrayList();
        for (IssueInputParametersAssembler.Result assemblerResult : createAssemblerResults) {
            if (assemblerResult.getErrors().hasAnyErrors()) {
                ErrorCollection errorCollection = ErrorCollection.of(assemblerResult.getErrors());
                errorCollections.add(new BulkOperationErrorResult(errorCollection.getStatus(), ErrorCollection.of(assemblerResult.getErrors()), createAssemblerResults.indexOf(assemblerResult)));
                continue;
            }
            IssueInputParameters parameters = assemblerResult.getParameters();
            try {
                MutableIssue issue = assemblerResult.getParentIdorKey() == null ? this.createIssue(parameters) : this.createSubtask(parameters, assemblerResult.getParentIdorKey());
                IssueCreateResponse response = new IssueCreateResponse().id(issue.getId().toString()).key(issue.getKey()).self(this.resourceUriBuilder.build(uriInfo, IssueResource.class, String.valueOf(issue.getId())).toString());
                createdIssues.add(response);
            }
            catch (WebApplicationException webEx) {
                ErrorCollection entity = (ErrorCollection)webEx.getResponse().getEntity();
                errorCollections.add(new BulkOperationErrorResult(entity.getStatus(), entity, createAssemblerResults.indexOf(assemblerResult)));
            }
        }
        if (errorCollections.size() == createAssemblerResults.size()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new IssuesCreateResponse(createdIssues, errorCollections)).cacheControl(CacheControl.never()).build());
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)new IssuesCreateResponse(createdIssues, errorCollections)).build();
    }

    private MutableIssue createSubtask(IssueInputParameters parameters, String parentIdOrKey) {
        IssueService.IssueResult parentIssueResult;
        User user = this.callingUser();
        try {
            Long id = Long.parseLong(parentIdOrKey);
            parentIssueResult = this.issueService.getIssue(user, id);
        }
        catch (NumberFormatException nfe) {
            parentIssueResult = this.issueService.getIssue(user, parentIdOrKey);
        }
        if (!parentIssueResult.isValid()) {
            throw this.error(ErrorCollection.of(parentIssueResult.getErrorCollection()));
        }
        IssueService.CreateValidationResult validation = this.issueService.validateSubTaskCreate(user, parentIssueResult.getIssue().getId(), parameters);
        if (!validation.isValid()) {
            throw this.error(ErrorCollection.of(validation.getErrorCollection()));
        }
        IssueService.IssueResult issueResult = this.issueService.create(user, validation);
        if (!issueResult.isValid()) {
            throw this.error(ErrorCollection.of(issueResult.getErrorCollection()));
        }
        MutableIssue subtask = issueResult.getIssue();
        try {
            this.subTaskManager.createSubTaskIssueLink((Issue)parentIssueResult.getIssue(), (Issue)subtask, user);
            return subtask;
        }
        catch (CreateException e) {
            SimpleErrorCollection errors = new SimpleErrorCollection();
            errors.addErrorMessage(this.jiraAuthenticationContext.getI18nHelper().getText("admin.errors.project.import.issue.link.error"));
            throw this.error(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errors));
        }
    }

    private MutableIssue createIssue(IssueInputParameters parameters) {
        User user = this.callingUser();
        IssueService.CreateValidationResult validation = this.issueService.validateCreate(user, parameters);
        if (!validation.isValid()) {
            throw this.error(ErrorCollection.of(validation.getErrorCollection()));
        }
        IssueService.IssueResult issueResult = this.issueService.create(user, validation);
        if (!issueResult.isValid()) {
            throw this.error(ErrorCollection.of(issueResult.getErrorCollection()));
        }
        return issueResult.getIssue();
    }

    protected WebApplicationException error(ErrorCollection errors) {
        this.convertFieldNames(errors);
        return new WebApplicationException(Response.status((int)errors.getStatus()).entity((Object)errors).cacheControl(CacheControl.never()).build());
    }

    protected WebApplicationException error(Response.Status status, ErrorCollection errors) {
        this.convertFieldNames(errors);
        throw new WebApplicationException(Response.status((Response.Status)status).entity((Object)errors).cacheControl(CacheControl.never()).build());
    }

    private void convertFieldNames(ErrorCollection errors) {
        Map fieldNameMappings = MapBuilder.newBuilder().add((Object)"pid", (Object)"project").toMap();
        for (Map.Entry entry : fieldNameMappings.entrySet()) {
            String oldName = (String)entry.getKey();
            String newName = (String)entry.getValue();
            if (!errors.getErrors().containsKey(oldName)) continue;
            String value = errors.getErrors().get(oldName);
            errors.getErrors().put(newName, value);
            errors.getErrors().remove(oldName);
        }
    }

    protected User callingUser() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }
}

