/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.MutableComment;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.fields.rest.json.beans.CommentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.CommentsWithPaginationJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.VisibilityJsonBean;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.v2.issue.IssueFinder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

public class CommentResource {
    private static final Logger log = Logger.getLogger(CommentResource.class);
    private static final String COMMENT_FIELD_KEY = "comment";
    private CommentService commentService;
    private JiraAuthenticationContext authContext;
    private I18nHelper i18n;
    private ProjectRoleManager projectRoleManager;
    private JiraBaseUrls jiraBaseUrls;
    private IssueFinder issueFinder;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final RendererManager rendererManager;
    private final FieldLayoutManager fieldLayoutManager;

    private CommentResource(IssueFinder issueFinder, DateTimeFormatterFactory dateTimeFormatterFactory, RendererManager rendererManager, FieldLayoutManager fieldLayoutManager) {
        this.issueFinder = issueFinder;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.rendererManager = rendererManager;
        this.fieldLayoutManager = fieldLayoutManager;
    }

    public CommentResource(CommentService commentService, JiraAuthenticationContext authContext, I18nHelper i18n, ProjectRoleManager projectRoleManager, JiraBaseUrls jiraBaseUrls, IssueFinder issueFinder, DateTimeFormatterFactory dateTimeFormatterFactory, RendererManager rendererManager, FieldLayoutManager fieldLayoutManager) {
        this.authContext = authContext;
        this.commentService = commentService;
        this.i18n = i18n;
        this.projectRoleManager = projectRoleManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.issueFinder = issueFinder;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.rendererManager = rendererManager;
        this.fieldLayoutManager = fieldLayoutManager;
    }

    public Response getComments(String issueIdOrKey, String expand) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        if (issue == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.comment.error.issue.invalid", issueIdOrKey)));
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        List commentsForUser = this.commentService.getCommentsForUser(this.authContext.getUser(), (Issue)issue, (com.atlassian.jira.util.ErrorCollection)errorCollection);
        if (!errorCollection.hasAnyErrors()) {
            Collection commentJsonBeans = expand != null ? CommentJsonBean.expandedShortBeans((Collection)commentsForUser, (JiraBaseUrls)this.jiraBaseUrls, (ProjectRoleManager)this.projectRoleManager, (DateTimeFormatterFactory)this.dateTimeFormatterFactory, (RendererManager)this.rendererManager, (String)this.getCommentFieldRendererType((Issue)issue), (IssueRenderContext)issue.getIssueRenderContext(), (String)expand) : CommentJsonBean.shortBeans((Collection)commentsForUser, (JiraBaseUrls)this.jiraBaseUrls, (ProjectRoleManager)this.projectRoleManager);
            CommentsWithPaginationJsonBean commentsBean = new CommentsWithPaginationJsonBean();
            commentsBean.setComments(commentJsonBeans);
            commentsBean.setStartAt(Integer.valueOf(0));
            commentsBean.setMaxResults(Integer.valueOf(commentJsonBeans.size()));
            commentsBean.setTotal(Integer.valueOf(commentJsonBeans.size()));
            return Response.ok((Object)commentsBean).cacheControl(CacheControl.never()).build();
        }
        throw new NotFoundWebException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
    }

    public Response getComment(String issueIdOrKey, String commentId, String expand) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        if (issue == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.comment.error.issue.invalid", issueIdOrKey)));
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        try {
            Comment comment = this.commentService.getCommentById(this.authContext.getUser(), Long.valueOf(Long.parseLong(commentId)), (com.atlassian.jira.util.ErrorCollection)errorCollection);
            if (errorCollection.hasAnyErrors()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection)).cacheControl(CacheControl.never()).build();
            }
            if (!issue.equals(comment.getIssue())) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of(this.i18n.getText("rest.comment.error.invalidIssueForComment", issue.getKey()))).cacheControl(CacheControl.never()).build();
            }
            if (expand != null) {
                return Response.ok((Object)CommentJsonBean.expandedShortBean((Comment)comment, (JiraBaseUrls)this.jiraBaseUrls, (ProjectRoleManager)this.projectRoleManager, (DateTimeFormatterFactory)this.dateTimeFormatterFactory, (RendererManager)this.rendererManager, (String)this.getCommentFieldRendererType((Issue)issue), (IssueRenderContext)issue.getIssueRenderContext(), (String)expand)).cacheControl(CacheControl.never()).build();
            }
            return Response.ok((Object)CommentJsonBean.shortBean((Comment)comment, (JiraBaseUrls)this.jiraBaseUrls, (ProjectRoleManager)this.projectRoleManager)).cacheControl(CacheControl.never()).build();
        }
        catch (NumberFormatException e) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("comment.service.error.no.comment.for.id", commentId)));
        }
    }

    public Response updateComment(String issueIdOrKey, String commentId, final String expand, CommentJsonBean request) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (request.getId() != null && !request.getId().equals(commentId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of(this.i18n.getText("rest.comment.error.id.mismatch"))).cacheControl(CacheControl.never()).build();
        }
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        if (issue == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of(this.i18n.getText("rest.comment.error.issue.invalid", issueIdOrKey))).cacheControl(CacheControl.never()).build();
        }
        try {
            final MutableComment comment = this.commentService.getMutableComment(this.authContext.getUser(), Long.valueOf(Long.parseLong(commentId)), (com.atlassian.jira.util.ErrorCollection)errorCollection);
            if (errorCollection.hasAnyErrors()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection)).cacheControl(CacheControl.never()).build();
            }
            if (comment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of(this.i18n.getText("comment.service.error.no.comment.for.id", commentId))).cacheControl(CacheControl.never()).build();
            }
            if (!issue.equals(comment.getIssue())) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of(this.i18n.getText("rest.comment.error.invalidIssueForComment", issue.getKey()))).cacheControl(CacheControl.never()).build();
            }
            if (request.isBodySet()) {
                comment.setBody(request.getBody());
            }
            if (request.isVisibilitySet()) {
                CommentVisibility visibilityParams = this.getCommentVisibilityParams(request);
                comment.setGroupLevel(visibilityParams.group);
                comment.setRoleLevelId(visibilityParams.roleId);
            }
            final ApplicationUser user = this.authContext.getUser();
            CommentService.CommentParameters commentParameters = CommentService.CommentParameters.builder().author(user).body(request.getBody()).commentProperties(this.getCommentProperties(request.getProperties())).groupLevel(comment.getGroupLevel()).issue((Issue)issue).roleLevelId(comment.getRoleLevelId()).build();
            final CommentService.CommentUpdateValidationResult commentValidationResult = this.commentService.validateCommentUpdate(user, comment.getId(), commentParameters);
            return (Response)commentValidationResult.getCommentProperties().fold((Supplier)new Supplier<Response>(){

                public Response get() {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of(commentValidationResult.getErrorCollection())).cacheControl(CacheControl.never()).build();
                }
            }, (Function)new Function<Map<String, JSONObject>, Response>((Issue)issue){
                final /* synthetic */ Issue val$issue;
                {
                    this.val$issue = issue;
                }

                public Response apply(Map<String, JSONObject> properties) {
                    CommentResource.this.commentService.update(user, commentValidationResult, true);
                    CommentJsonBean bean = expand != null ? CommentJsonBean.expandedShortBean((Comment)comment, (JiraBaseUrls)CommentResource.this.jiraBaseUrls, (ProjectRoleManager)CommentResource.this.projectRoleManager, (DateTimeFormatterFactory)CommentResource.this.dateTimeFormatterFactory, (RendererManager)CommentResource.this.rendererManager, (String)CommentResource.this.getCommentFieldRendererType(this.val$issue), (IssueRenderContext)this.val$issue.getIssueRenderContext(), (String)expand) : CommentJsonBean.shortBean((Comment)comment, (JiraBaseUrls)CommentResource.this.jiraBaseUrls, (ProjectRoleManager)CommentResource.this.projectRoleManager);
                    return Response.ok((Object)bean).location(CommentResource.this.getUri(bean)).cacheControl(CacheControl.never()).build();
                }
            });
        }
        catch (NumberFormatException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of(this.i18n.getText("comment.service.error.no.comment.for.id", commentId))).cacheControl(CacheControl.never()).build();
        }
    }

    public Response deleteComment(String issueIdOrKey, String commentId) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        if (issue == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.comment.error.issue.invalid", issueIdOrKey)));
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        try {
            Comment comment = this.commentService.getCommentById(this.authContext.getUser(), Long.valueOf(Long.parseLong(commentId)), (com.atlassian.jira.util.ErrorCollection)errorCollection);
            if (errorCollection.hasAnyErrors()) {
                throw new NotFoundWebException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
            }
            if (!issue.equals(comment.getIssue())) {
                throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.comment.error.invalidIssueForComment", issue.getKey())));
            }
            JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(this.authContext.getUser(), (com.atlassian.jira.util.ErrorCollection)errorCollection);
            this.commentService.delete((JiraServiceContext)jiraServiceContext, comment, true);
            if (errorCollection.hasAnyErrors()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection)).cacheControl(CacheControl.never()).build();
            }
            return Response.noContent().cacheControl(CacheControl.never()).build();
        }
        catch (NumberFormatException e) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("comment.service.error.no.comment.for.id", commentId)));
        }
    }

    public Response addComment(String issueIdOrKey, final String expand, CommentJsonBean request) {
        MutableIssue issue = this.issueFinder.getIssueObject(issueIdOrKey);
        if (issue == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of(this.i18n.getText("rest.comment.error.issue.invalid", issueIdOrKey))).cacheControl(CacheControl.never()).build();
        }
        final ApplicationUser user = this.authContext.getUser();
        CommentVisibility commentVisibility = this.getCommentVisibilityParams(request);
        CommentService.CommentParameters commentParameters = CommentService.CommentParameters.builder().author(user).body(request.getBody()).commentProperties(this.getCommentProperties(request.getProperties())).groupLevel(commentVisibility.group).issue((Issue)issue).roleLevelId(commentVisibility.roleId).build();
        final CommentService.CommentCreateValidationResult commentValidationResult = this.commentService.validateCommentCreate(user, commentParameters);
        return (Response)commentValidationResult.getCommentInputParameters().fold((Supplier)new Supplier<Response>(){

            public Response get() {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of(commentValidationResult.getErrorCollection())).cacheControl(CacheControl.never()).build();
            }
        }, (Function)new Function<CommentService.CommentParameters, Response>((Issue)issue){
            final /* synthetic */ Issue val$issue;
            {
                this.val$issue = issue;
            }

            public Response apply(CommentService.CommentParameters commentParameters) {
                Comment comment = CommentResource.this.commentService.create(user, commentValidationResult, true);
                CommentJsonBean entity = expand != null ? CommentJsonBean.expandedShortBean((Comment)comment, (JiraBaseUrls)CommentResource.this.jiraBaseUrls, (ProjectRoleManager)CommentResource.this.projectRoleManager, (DateTimeFormatterFactory)CommentResource.this.dateTimeFormatterFactory, (RendererManager)CommentResource.this.rendererManager, (String)CommentResource.this.getCommentFieldRendererType(this.val$issue), (IssueRenderContext)this.val$issue.getIssueRenderContext(), (String)expand) : CommentJsonBean.shortBean((Comment)comment, (JiraBaseUrls)CommentResource.this.jiraBaseUrls, (ProjectRoleManager)CommentResource.this.projectRoleManager);
                return Response.status((Response.Status)Response.Status.CREATED).location(CommentResource.this.getUri(entity)).entity((Object)entity).cacheControl(CacheControl.never()).build();
            }
        });
    }

    private CommentVisibility getCommentVisibilityParams(CommentJsonBean request) {
        if (request.getVisibility() != null) {
            VisibilityJsonBean visibility = request.getVisibility();
            if (visibility.type == VisibilityJsonBean.VisibilityType.role) {
                Long role = this.projectRoleManager.getProjectRole(visibility.value).getId();
                return new CommentVisibility(VisibilityJsonBean.VisibilityType.role, null, role);
            }
            String group = visibility.value;
            return new CommentVisibility(VisibilityJsonBean.VisibilityType.group, group, null);
        }
        return new CommentVisibility(null, null, null);
    }

    private URI getUri(CommentJsonBean comment) {
        try {
            return new URI(comment.getSelf());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private String getCommentFieldRendererType(Issue issue) {
        FieldLayout layout = this.fieldLayoutManager.getFieldLayout(issue);
        List fieldLayoutItems = layout.getVisibleLayoutItems(issue.getProjectObject(), CollectionBuilder.list((Object[])new String[]{issue.getIssueTypeObject().getId()}));
        for (FieldLayoutItem item : fieldLayoutItems) {
            if (!COMMENT_FIELD_KEY.equals(item.getOrderableField().getId())) continue;
            return item.getRendererType();
        }
        return null;
    }

    private Map<String, JSONObject> getCommentProperties(List<EntityPropertyBean> properties) {
        HashMap mapOfProperties = Maps.newHashMap();
        if (properties != null) {
            for (EntityPropertyBean propertyBean : properties) {
                try {
                    mapOfProperties.put(propertyBean.getKey(), new JSONObject(propertyBean.getValue()));
                }
                catch (JSONException e) {
                    log.error((Object)"Error when building comment properties", (Throwable)e);
                }
            }
        }
        return mapOfProperties;
    }

    private class CommentVisibility {
        VisibilityJsonBean.VisibilityType type;
        String group;
        Long roleId;

        private CommentVisibility(VisibilityJsonBean.VisibilityType type, String group, Long roleId) {
            this.type = type;
            this.group = group;
            this.roleId = roleId;
        }
    }
}

