/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.fugue.Function2;
import com.atlassian.jira.bc.issue.comment.property.CommentPropertyService;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBeanSelfFunctions;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.v2.entity.property.BasePropertyResource;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="comment/{commentId}/properties")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CommentPropertyResource {
    private final BasePropertyResource<Comment> delegate;

    public CommentPropertyResource(CommentPropertyService commentPropertyService, JiraAuthenticationContext authenticationContext, JiraBaseUrls jiraBaseUrls, I18nHelper i18n) {
        this.delegate = new BasePropertyResource(commentPropertyService, authenticationContext, jiraBaseUrls, i18n, (Function2<Long, String, String>)new EntityPropertyBeanSelfFunctions.CommentPropertySelfFunction(), EntityPropertyType.COMMENT_PROPERTY);
    }

    @ExperimentalApi
    @GET
    public Response getPropertiesKeys(@PathParam(value="commentId") String commentId) {
        return this.delegate.getPropertiesKeys(commentId);
    }

    @ExperimentalApi
    @PUT
    @Path(value="/{propertyKey}")
    public Response setProperty(@PathParam(value="commentId") String commentId, @PathParam(value="propertyKey") String propertyKey, @Context HttpServletRequest request) {
        return this.delegate.setProperty(commentId, propertyKey, request);
    }

    @ExperimentalApi
    @GET
    @Path(value="/{propertyKey}")
    public Response getProperty(@PathParam(value="commentId") String commentId, @PathParam(value="propertyKey") String propertyKey) {
        return this.delegate.getProperty(commentId, propertyKey);
    }

    @ExperimentalApi
    @DELETE
    @Path(value="/{propertyKey}")
    public Response deleteProperty(@PathParam(value="commentId") String commentId, @PathParam(value="propertyKey") String propertyKey) {
        return this.delegate.deleteProperty(commentId, propertyKey);
    }
}

