/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarPickerHelper;
import com.atlassian.jira.avatar.AvatarPickerHelperImpl;
import com.atlassian.jira.avatar.Selection;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.util.AttachmentHelper;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.rest.v2.issue.AvatarBean;
import com.atlassian.jira.rest.v2.issue.AvatarBeanFactory;
import com.atlassian.jira.rest.v2.issue.AvatarCroppingBean;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.json.JSONEscaper;
import com.atlassian.plugins.rest.common.multipart.FilePart;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

public class AvatarResourceHelper {
    private JiraAuthenticationContext authContext;
    private AvatarManager avatarManager;
    private AvatarPickerHelper avatarPickerHelper;
    private AttachmentHelper attachmentHelper;

    public AvatarResourceHelper(JiraAuthenticationContext authContext, AvatarManager avatarManager, AvatarPickerHelper avatarPickerHelper, AttachmentHelper attachmentHelper) {
        this.authContext = authContext;
        this.avatarManager = avatarManager;
        this.avatarPickerHelper = avatarPickerHelper;
        this.attachmentHelper = attachmentHelper;
    }

    public Response getAllAvatars(Avatar.Type type, String ownerId, Long selectedAvatarId) {
        if (selectedAvatarId == null) {
            selectedAvatarId = this.avatarManager.getDefaultAvatarId(type);
        }
        HashMap<String, List<AvatarBean>> avatars = new HashMap<String, List<AvatarBean>>();
        List<AvatarBean> systemAvatarBeans = AvatarBeanFactory.createAvatarBeans(this.avatarManager.getAllSystemAvatars(type));
        this.setSelectedAvatar(selectedAvatarId, systemAvatarBeans);
        avatars.put("system", systemAvatarBeans);
        List<AvatarBean> customAvatarBeans = AvatarBeanFactory.createAvatarBeans(this.avatarManager.getCustomAvatarsForOwner(type, ownerId));
        avatars.put("custom", customAvatarBeans);
        this.setSelectedAvatar(selectedAvatarId, customAvatarBeans);
        return Response.ok(avatars).cacheControl(CacheControl.NO_CACHE).build();
    }

    public Response getAllSystemAvatars(Avatar.Type type) {
        HashMap<String, List<AvatarBean>> avatars = new HashMap<String, List<AvatarBean>>();
        List<AvatarBean> systemAvatarBeans = AvatarBeanFactory.createAvatarBeans(this.avatarManager.getAllSystemAvatars(type));
        avatars.put("system", systemAvatarBeans);
        return Response.ok(avatars).cacheControl(CacheControl.NO_CACHE).build();
    }

    private void setSelectedAvatar(Long selectedAvatarId, List<AvatarBean> avatars) {
        if (selectedAvatarId != null) {
            for (AvatarBean avatar : avatars) {
                if (!avatar.getId().equals(selectedAvatarId.toString())) continue;
                avatar.setSelected(true);
                break;
            }
        }
    }

    public Response createAvatarFromTemporary(Avatar.Type type, String ownerId, AvatarCroppingBean croppingInstructions) {
        Selection selection = new Selection(croppingInstructions.getCropperOffsetX(), croppingInstructions.getCropperOffsetY(), croppingInstructions.getCropperWidth(), croppingInstructions.getCropperWidth());
        AvatarPickerHelperImpl.Result conversionResult = this.avatarPickerHelper.convertTemporaryToReal(ownerId, type, selection);
        if (!conversionResult.isValid()) {
            this.throwWebException(conversionResult.getErrorCollection());
        }
        AvatarBean avatarBean = AvatarBeanFactory.createAvatarBean((Avatar)conversionResult.getResult());
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)avatarBean).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
    }

    public Response storeTemporaryAvatar(Avatar.Type type, String ownerId, String filename, Long size, HttpServletRequest request) {
        AvatarPickerHelperImpl.Result tempAvatarResult;
        AttachmentHelper.ValidationResult validationResult = this.attachmentHelper.validate(request, filename, size);
        if (!validationResult.isValid()) {
            this.throwWebException(validationResult.getErrorMessage(), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (!(tempAvatarResult = this.avatarPickerHelper.upload(validationResult.getInputStream(), filename, validationResult.getContentType(), validationResult.getSize(), ownerId, type)).isValid()) {
            this.throwWebException(tempAvatarResult.getErrorCollection());
        }
        AvatarCroppingBean croppingInstructions = AvatarBeanFactory.createTemporaryAvatarCroppingInstructions((AvatarPickerHelperImpl.TemporaryAvatarBean)tempAvatarResult.getResult());
        if (((AvatarPickerHelperImpl.TemporaryAvatarBean)tempAvatarResult.getResult()).isCroppingNeeded()) {
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)croppingInstructions).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
        }
        return this.createAvatarFromTemporary(type, ownerId, croppingInstructions);
    }

    public Response storeTemporaryAvatarUsingMultiPart(Avatar.Type type, String ownerId, FilePart filePart, HttpServletRequest request) {
        String filename = filePart.getName();
        AttachmentHelper.ValidationResult validationResult = this.attachmentHelper.validate(request, filename, null);
        if (!validationResult.isValid()) {
            ArrayList<String> errorMessages = new ArrayList<String>();
            errorMessages.add(validationResult.getErrorMessage());
            return this.returnErrorMessagesAsHtml(errorMessages);
        }
        String fullPath = filePart.getName();
        String fileName = fullPath.substring(fullPath.lastIndexOf("\\") + 1, fullPath.length());
        try {
            AvatarPickerHelperImpl.Result tempAvatarResult = this.avatarPickerHelper.upload(filePart.getInputStream(), fileName, filePart.getContentType(), -1L, ownerId, type);
            if (!tempAvatarResult.isValid()) {
                return this.returnErrorMessagesAsHtml(tempAvatarResult.getErrorCollection().getErrorMessages());
            }
            AvatarPickerHelperImpl.TemporaryAvatarBean temporaryAvatarBean = (AvatarPickerHelperImpl.TemporaryAvatarBean)tempAvatarResult.getResult();
            if (temporaryAvatarBean.isCroppingNeeded()) {
                return Response.status((Response.Status)Response.Status.CREATED).entity((Object)("<html><body><textarea>{\"url\": \"" + temporaryAvatarBean.getUrl() + "\"," + "\"cropperWidth\": \"" + temporaryAvatarBean.getCropperWidth() + "\"," + "\"cropperOffsetX\": \"" + temporaryAvatarBean.getCropperOffsetX() + "\"," + "\"cropperOffsetY\": \"" + temporaryAvatarBean.getCropperOffsetY() + "\"," + "\"isCroppingNeeded\": \"" + temporaryAvatarBean.isCroppingNeeded() + "\"" + "}" + "</textarea>" + "</body></html>")).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
            }
            Selection selection = new Selection(temporaryAvatarBean.getCropperOffsetX(), temporaryAvatarBean.getCropperOffsetY(), temporaryAvatarBean.getCropperWidth(), temporaryAvatarBean.getCropperWidth());
            AvatarPickerHelperImpl.Result conversionResult = this.avatarPickerHelper.convertTemporaryToReal(ownerId, type, selection);
            if (!conversionResult.isValid()) {
                return this.returnErrorMessagesAsHtml(conversionResult.getErrorCollection().getErrorMessages());
            }
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)("<html><body><textarea>{\"id\": \"" + ((Avatar)conversionResult.getResult()).getId() + "\"" + "}" + "</textarea>" + "</body></html>")).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Response cropTemporaryAvatar(Avatar.Type type, String ownerId, AvatarCroppingBean croppingInstructions) {
        Selection selection = new Selection(croppingInstructions.getCropperOffsetX(), croppingInstructions.getCropperOffsetY(), croppingInstructions.getCropperWidth(), croppingInstructions.getCropperWidth());
        AvatarPickerHelperImpl.Result cropResult = this.avatarPickerHelper.cropTemporary(ownerId, type, selection);
        if (!cropResult.isValid()) {
            this.throwWebException(cropResult.getErrorCollection());
        }
        return Response.status((Response.Status)Response.Status.OK).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
    }

    public Response deleteAvatar(@PathParam(value="id") Long id) {
        Avatar avatar = this.avatarManager.getById(id);
        if (avatar == null) {
            throw new NotFoundWebException();
        }
        if (!this.avatarManager.hasPermissionToEdit(this.authContext.getLoggedInUser(), avatar.getAvatarType(), avatar.getOwner())) {
            throw new NotAuthorisedWebException();
        }
        boolean deleted = this.avatarManager.delete(id, true);
        if (deleted) {
            return Response.noContent().cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
    }

    private AttachmentHelper.ValidationResult validateAttachment(HttpServletRequest request, @Nullable String filename, @Nullable Long size) {
        AttachmentHelper.ValidationResult validationResult = this.attachmentHelper.validate(request, filename, size);
        if (!validationResult.isValid()) {
            if (validationResult.getErrorType() == AttachmentHelper.ValidationError.XSRF_TOKEN_INVALID) {
                this.throwWebException(this.authContext.getI18nHelper().getText("xsrf.error.title"), ErrorCollection.Reason.FORBIDDEN);
            } else if (validationResult.getErrorType() == AttachmentHelper.ValidationError.ATTACHMENT_IO_SIZE) {
                String message = this.authContext.getI18nHelper().getText("attachfile.error.io.size", filename);
                this.throwWebException(message, ErrorCollection.Reason.SERVER_ERROR);
            } else {
                String message = this.authContext.getI18nHelper().getText("attachfile.error.io.error", filename, validationResult.getErrorMessage());
                this.throwWebException(message, ErrorCollection.Reason.SERVER_ERROR);
            }
        }
        return validationResult;
    }

    private Response returnErrorMessagesAsHtml(Collection<String> errorMessages) {
        String errorMsgs = "";
        String sep = "";
        for (String errorMessage : errorMessages) {
            errorMsgs = errorMsgs + "\"" + JSONEscaper.escape((String)errorMessage) + "\"" + sep;
            sep = ",";
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)("<html><body><textarea>{\"errorMessages\": [" + errorMsgs + "]" + "}" + "</textarea>" + "</body></html>")).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
    }

    private void throwWebException(String message, ErrorCollection.Reason reason) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorMessage(message, reason);
        this.throwWebException((com.atlassian.jira.util.ErrorCollection)errorCollection);
    }

    private void throwWebException(com.atlassian.jira.util.ErrorCollection errorCollection) {
        throw new RESTException(ErrorCollection.of(errorCollection));
    }
}

