/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarPickerHelper;
import com.atlassian.jira.rest.util.AttachmentHelper;
import com.atlassian.jira.rest.v2.issue.AvatarCroppingBean;
import com.atlassian.jira.rest.v2.issue.AvatarResourceHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="avatar")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AvatarResource {
    private final AvatarResourceHelper avatarResourceHelper;

    public AvatarResource(JiraAuthenticationContext authContext, AvatarManager avatarManager, AvatarPickerHelper avatarPickerHelper, AttachmentHelper attachmentHelper) {
        this.avatarResourceHelper = new AvatarResourceHelper(authContext, avatarManager, avatarPickerHelper, attachmentHelper);
    }

    @GET
    @Path(value="{type}/system")
    public Response getAllSystemAvatars(@PathParam(value="type") String type) {
        return this.avatarResourceHelper.getAllSystemAvatars(Avatar.Type.getByName((String)type));
    }

    @POST
    @Consumes(value={"*/*"})
    @Path(value="{type}/temporary")
    public Response storeTemporaryAvatar(@PathParam(value="type") String type, @QueryParam(value="filename") String filename, @QueryParam(value="size") Long size, @Context HttpServletRequest request) {
        return this.avatarResourceHelper.storeTemporaryAvatar(Avatar.Type.getByName((String)type), null, filename, size, request);
    }

    @POST
    @Path(value="{type}/temporaryCrop")
    public Response createAvatarFromTemporary(@PathParam(value="type") String type, AvatarCroppingBean croppingInstructions) {
        return this.avatarResourceHelper.cropTemporaryAvatar(Avatar.Type.getByName((String)type), null, croppingInstructions);
    }
}

