/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.exception.AttachmentNotFoundException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.v2.issue.AttachmentBean;
import com.atlassian.jira.rest.v2.issue.AttachmentMetaBean;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.rest.v2.issue.context.ContextUriInfo;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import webwork.config.Configuration;

@Path(value="attachment")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AttachmentResource {
    private static final Logger log = Logger.getLogger(AttachmentResource.class);
    private PermissionManager permissionManager;
    private AttachmentManager attachmentManager;
    private AttachmentService attachmentService;
    private JiraAuthenticationContext authContext;
    private BeanBuilderFactory beanBuilderFactory;
    private I18nHelper i18n;
    private ContextUriInfo uriInfo;

    private AttachmentResource() {
    }

    public AttachmentResource(AttachmentService attachmentService, AttachmentManager attachmentManager, PermissionManager permissionManager, JiraAuthenticationContext authContext, BeanBuilderFactory beanBuilderFactory, I18nHelper i18n, ContextUriInfo uriInfo) {
        this.attachmentManager = attachmentManager;
        this.attachmentService = attachmentService;
        this.permissionManager = permissionManager;
        this.authContext = authContext;
        this.beanBuilderFactory = beanBuilderFactory;
        this.i18n = i18n;
        this.uriInfo = uriInfo;
    }

    @GET
    @Path(value="{id}")
    public Response getAttachment(@PathParam(value="id") String id) {
        if (!this.attachmentManager.attachmentsEnabled()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
        }
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(this.authContext.getLoggedInUser());
        try {
            Attachment attachment = this.attachmentService.getAttachment((JiraServiceContext)serviceContext, Long.valueOf(Long.parseLong(id)));
            if (serviceContext.getErrorCollection().hasAnyErrors()) {
                ErrorCollection errors = ErrorCollection.of(serviceContext.getErrorCollection());
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errors).cacheControl(CacheControl.never()).build();
            }
            if (!this.hasPermissionToViewAttachment(this.authContext.getLoggedInUser(), attachment)) {
                throw new RESTException(Response.Status.FORBIDDEN, ErrorCollection.of(this.i18n.getText("attachment.service.error.view.no.permission", id)));
            }
            AttachmentBean bean = this.beanBuilderFactory.newAttachmentBeanBuilder(attachment).build();
            return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
        }
        catch (AttachmentNotFoundException e) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.attachment.error.not.found", id)));
        }
        catch (NumberFormatException e) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.attachment.error.not.found", id)));
        }
    }

    @DELETE
    @Path(value="{id}")
    public Response removeAttachment(@PathParam(value="id") String id) {
        Long attachmentId;
        if (!this.attachmentManager.attachmentsEnabled()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
        }
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(this.authContext.getLoggedInUser());
        try {
            attachmentId = Long.parseLong(id);
            this.attachmentService.getAttachment((JiraServiceContext)serviceContext, attachmentId);
        }
        catch (AttachmentNotFoundException e) {
            throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(this.i18n.getText("rest.attachment.error.not.found", id)));
        }
        catch (NumberFormatException e) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.attachment.error.not.found", id)));
        }
        if (!this.attachmentService.canDeleteAttachment((JiraServiceContext)serviceContext, attachmentId)) {
            throw new RESTException(Response.Status.FORBIDDEN, ErrorCollection.of(this.i18n.getText("attachment.service.error.delete.no.permission", id)));
        }
        try {
            this.attachmentService.delete((JiraServiceContext)serviceContext, attachmentId);
            return Response.noContent().build();
        }
        catch (Exception e) {
            log.error((Object)"Error deleting attachment", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    protected boolean hasPermissionToViewAttachment(User user, Attachment attachment) throws DataAccessException {
        Issue issue = attachment.getIssueObject();
        return this.permissionManager.hasPermission(10, issue, user);
    }

    @GET
    @Path(value="meta")
    public Response getAttachmentMeta() {
        boolean enabled = this.attachmentManager.attachmentsEnabled();
        long maxSize = Long.parseLong(Configuration.getString((String)"webwork.multipart.maxSize"));
        AttachmentMetaBean bean = new AttachmentMetaBean(enabled, maxSize);
        return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
    }
}

