/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.entity.property;

import com.atlassian.fugue.Function2;
import com.atlassian.fugue.Option;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.BadRequestWebException;
import com.atlassian.jira.rest.util.RestStringUtils;
import com.atlassian.jira.rest.v2.entity.property.EntityPropertiesKeysBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.io.LimitInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;

public class BasePropertyResource<E extends WithId> {
    private final EntityPropertyService<E> entityPropertyService;
    private final JiraAuthenticationContext authContext;
    private final JiraBaseUrls jiraBaseUrls;
    private final I18nHelper i18n;
    private final EntityPropertyType entityPropertyType;
    private final Function2<Long, String, String> entityIdAndPropertyKeyToSelfFunction;

    public BasePropertyResource(EntityPropertyService<E> entityPropertyService, JiraAuthenticationContext authContext, JiraBaseUrls jiraBaseUrls, I18nHelper i18n, Function2<Long, String, String> entityIdAndPropertyKeyToSelfFunction, EntityPropertyType entityPropertyType) {
        this.entityPropertyService = entityPropertyService;
        this.authContext = authContext;
        this.jiraBaseUrls = jiraBaseUrls;
        this.i18n = i18n;
        this.entityPropertyType = (EntityPropertyType)Preconditions.checkNotNull((Object)entityPropertyType);
        this.entityIdAndPropertyKeyToSelfFunction = (Function2)Preconditions.checkNotNull(entityIdAndPropertyKeyToSelfFunction);
    }

    public Response getPropertiesKeys(String id) {
        ApplicationUser user = this.authContext.getUser();
        EntityPropertyService.PropertyKeys<E> propertyKeys = this.getPropertiesKeys(user, id);
        if (propertyKeys.isValid()) {
            EntityPropertiesKeysBean entity = EntityPropertiesKeysBean.build(this.jiraBaseUrls, ((WithId)propertyKeys.getEntity()).getId(), propertyKeys.getKeys(), this.entityIdAndPropertyKeyToSelfFunction);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).cacheControl(CacheControl.never()).build();
        }
        return this.error(propertyKeys.getErrorCollection());
    }

    public Response setProperty(String id, String propertyKey, HttpServletRequest request) {
        ApplicationUser user = this.authContext.getUser();
        EntityPropertyService.SetPropertyValidationResult setValidationResult = this.validateSetProperty(user, new EntityPropertyService.PropertyInput(this.propertyValue(request), propertyKey), id);
        if (setValidationResult.isValid()) {
            EntityPropertyService.PropertyResult property = this.getProperty(user, propertyKey, id);
            EntityPropertyService.PropertyResult propertyResult = this.entityPropertyService.setProperty(user, setValidationResult);
            if (!propertyResult.isValid()) {
                return this.error(propertyResult.getErrorCollection());
            }
            return (Response)property.getEntityProperty().fold((Supplier)new Supplier<Response>(){

                public Response get() {
                    return Response.status((Response.Status)Response.Status.CREATED).cacheControl(CacheControl.never()).build();
                }
            }, (Function)new Function<EntityProperty, Response>(){

                public Response apply(EntityProperty entityProperty) {
                    return Response.status((Response.Status)Response.Status.OK).cacheControl(CacheControl.never()).build();
                }
            });
        }
        return this.error(setValidationResult.getErrorCollection());
    }

    public Response getProperty(String entityId, final String propertyKey) {
        ApplicationUser user = this.authContext.getUser();
        EntityPropertyService.PropertyResult propertyResult = this.getProperty(user, propertyKey, entityId);
        if (propertyResult.isValid()) {
            Option property = propertyResult.getEntityProperty();
            return (Response)property.fold((Supplier)new Supplier<Response>(){

                public Response get() {
                    SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                    errorCollection.addErrorMessage(BasePropertyResource.this.i18n.getText("jira.properties.service.property.does.not.exist", propertyKey), ErrorCollection.Reason.NOT_FOUND);
                    return BasePropertyResource.this.error((com.atlassian.jira.util.ErrorCollection)errorCollection);
                }
            }, (Function)new Function<EntityProperty, Response>(){

                public Response apply(EntityProperty entityProperty) {
                    EntityPropertyBean entityPropertyBean = EntityPropertyBean.builder((JiraBaseUrls)BasePropertyResource.this.jiraBaseUrls, (Function2)BasePropertyResource.this.entityIdAndPropertyKeyToSelfFunction).value(RestStringUtils.escapeUnicode(entityProperty.getValue())).key(entityProperty.getKey()).build(entityProperty.getEntityId());
                    return Response.status((Response.Status)Response.Status.OK).entity((Object)entityPropertyBean).cacheControl(CacheControl.never()).build();
                }
            });
        }
        return this.error(propertyResult.getErrorCollection());
    }

    public Response deleteProperty(String id, String propertyKey) {
        ApplicationUser user = this.authContext.getUser();
        EntityPropertyService.DeletePropertyValidationResult deleteValidationResult = this.validateDeleteProperty(user, propertyKey, id);
        if (deleteValidationResult.isValid()) {
            this.entityPropertyService.deleteProperty(user, deleteValidationResult);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
        }
        return this.error(deleteValidationResult.getErrorCollection());
    }

    protected EntityPropertyService.PropertyKeys<E> getPropertiesKeys(final ApplicationUser user, String id) {
        return (EntityPropertyService.PropertyKeys)this.withIdValidation(id, new Function<Long, EntityPropertyService.PropertyKeys<E>>(){

            public EntityPropertyService.PropertyKeys<E> apply(Long entityId) {
                return BasePropertyResource.this.entityPropertyService.getPropertiesKeys(user, entityId);
            }
        });
    }

    protected EntityPropertyService.PropertyResult getProperty(final ApplicationUser user, final String propertyKey, String id) {
        return this.withIdValidation(id, new Function<Long, EntityPropertyService.PropertyResult>(){

            public EntityPropertyService.PropertyResult apply(Long entityId) {
                return BasePropertyResource.this.entityPropertyService.getProperty(user, entityId, propertyKey);
            }
        });
    }

    protected EntityPropertyService.DeletePropertyValidationResult validateDeleteProperty(final ApplicationUser user, final String propertyKey, String id) {
        return this.withIdValidation(id, new Function<Long, EntityPropertyService.DeletePropertyValidationResult>(){

            public EntityPropertyService.DeletePropertyValidationResult apply(Long id) {
                return BasePropertyResource.this.entityPropertyService.validateDeleteProperty(user, id, propertyKey);
            }
        });
    }

    protected EntityPropertyService.SetPropertyValidationResult validateSetProperty(final ApplicationUser user, final EntityPropertyService.PropertyInput propertyInput, String id) {
        return this.withIdValidation(id, new Function<Long, EntityPropertyService.SetPropertyValidationResult>(){

            public EntityPropertyService.SetPropertyValidationResult apply(Long entityId) {
                return BasePropertyResource.this.entityPropertyService.validateSetProperty(user, entityId, propertyInput);
            }
        });
    }

    protected <T> T withIdValidation(String id, Function<Long, T> idFunction) {
        return (T)idFunction.apply((Object)this.getLongOrBadRequest(id));
    }

    private Response error(com.atlassian.jira.util.ErrorCollection errorCollection) {
        ErrorCollection.Reason reason = ErrorCollection.Reason.getWorstReason((Collection)errorCollection.getReasons());
        return Response.status((int)reason.getHttpStatusCode()).entity((Object)ErrorCollection.of(errorCollection)).cacheControl(CacheControl.never()).build();
    }

    private Long getLongOrBadRequest(String idOrKey) {
        try {
            return Long.parseLong(idOrKey);
        }
        catch (NumberFormatException e) {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            errorCollection.addErrorMessage(this.i18n.getText("jira.properties.service.property.invalid.entity", this.i18n.getText(this.entityPropertyType.getI18nKeyForEntityName())));
            throw new BadRequestWebException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
        }
    }

    private String propertyValue(HttpServletRequest request) {
        try {
            LimitInputStream limitInputStream = new LimitInputStream((InputStream)request.getInputStream(), 32769L);
            byte[] bytes = IOUtils.toByteArray((InputStream)limitInputStream);
            if (bytes.length > 32768) {
                throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("jira.properties.service.length.unknown", (Object)32768)));
            }
            return new String(bytes, Charset.forName(ComponentAccessor.getApplicationProperties().getEncoding()));
        }
        catch (IOException e) {
            throw new BadRequestWebException(ErrorCollection.of(e.getMessage()));
        }
    }
}

