/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.workflowscheme;

import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public class WorkflowSchemeBean {
    @JsonProperty
    private Long id;
    @JsonProperty
    private String name;
    @JsonProperty
    private String description;
    @JsonProperty
    private String defaultWorkflow;
    @JsonProperty
    private Map<String, String> issueTypeMappings;
    @JsonProperty
    private String originalDefaultWorkflow;
    @JsonProperty
    private Map<String, String> originalIssueTypeMappings;
    @JsonProperty
    private Boolean draft;
    @JsonProperty
    private UserBean lastModifiedUser;
    @JsonProperty
    private String lastModified;
    @JsonProperty
    private URI self;
    @JsonProperty
    private Boolean updateDraftIfNeeded;
    @JsonProperty
    private Map<String, IssueTypeJsonBean> issueTypes;
    @JsonIgnore
    private boolean nameSet;
    @JsonIgnore
    private boolean descriptionSet;
    @JsonIgnore
    private boolean defaultSet;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDefaultWorkflow() {
        return this.defaultWorkflow;
    }

    public void setDefaultWorkflow(String defaultWorkflow) {
        this.defaultSet = true;
        this.defaultWorkflow = defaultWorkflow;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.descriptionSet = true;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.nameSet = true;
        this.name = name;
    }

    public URI getSelf() {
        return this.self;
    }

    public void setSelf(URI self) {
        this.self = self;
    }

    public Boolean isDraft() {
        return this.draft;
    }

    public void setDraft(Boolean draft) {
        this.draft = draft;
    }

    public void setLastModifiedUser(UserBean lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    public UserBean getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public Boolean isUpdateDraftIfNeeded() {
        return this.updateDraftIfNeeded;
    }

    public void setUpdateDraftIfNeeded(Boolean createDraftIfNeeded) {
        this.updateDraftIfNeeded = createDraftIfNeeded;
    }

    public boolean isDefaultSet() {
        return this.defaultSet;
    }

    public boolean isDescriptionSet() {
        return this.descriptionSet;
    }

    public boolean isNameSet() {
        return this.nameSet;
    }

    public String getOriginalDefaultWorkflow() {
        return this.originalDefaultWorkflow;
    }

    public void setOriginalDefaultWorkflow(String originalDefaultWorkflow) {
        this.originalDefaultWorkflow = originalDefaultWorkflow;
    }

    public Map<String, String> getIssueTypeMappings() {
        return this.issueTypeMappings;
    }

    public void setIssueTypeMappings(Map<String, String> issueTypeMappings) {
        this.issueTypeMappings = issueTypeMappings;
    }

    public Map<String, String> getOriginalIssueTypeMappings() {
        return this.originalIssueTypeMappings;
    }

    public void setOriginalIssueTypeMappings(Map<String, String> originalIssueTypeMappings) {
        this.originalIssueTypeMappings = originalIssueTypeMappings;
    }

    void addIssueTypeMapping(String issueType, String workflow) {
        if (this.issueTypeMappings == null) {
            this.issueTypeMappings = Maps.newHashMap();
        }
        this.issueTypeMappings.put(issueType, workflow);
    }

    void addOriginalIssueTypeMapping(String issueType, String workflow) {
        if (this.originalIssueTypeMappings == null) {
            this.originalIssueTypeMappings = Maps.newHashMap();
        }
        this.originalIssueTypeMappings.put(issueType, workflow);
    }

    public Map<String, IssueTypeJsonBean> getIssueTypes() {
        return this.issueTypes;
    }

    public void setIssueTypes(Map<String, IssueTypeJsonBean> issueTypes) {
        this.issueTypes = issueTypes;
    }
}

