/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.workflowscheme;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.workflow.WorkflowSchemeService;
import com.atlassian.jira.rest.v2.admin.workflowscheme.DefaultBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.DraftRestWorkflowScheme;
import com.atlassian.jira.rest.v2.admin.workflowscheme.IssueTypeMappingBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.RestWorkflowScheme;
import com.atlassian.jira.rest.v2.admin.workflowscheme.WorkflowMappingBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.WorkflowSchemeBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.WorkflowSchemeBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import java.util.Map;

public class AssignableRestWorkflowScheme
extends RestWorkflowScheme {
    private final WorkflowSchemeService workflowSchemeService;
    private final ApplicationUser user;
    private AssignableWorkflowScheme scheme;

    AssignableRestWorkflowScheme(WorkflowSchemeService workflowSchemeService, ApplicationUser user, WorkflowSchemeBeanFactory beanFactory, AssignableWorkflowScheme scheme) {
        super(beanFactory);
        this.workflowSchemeService = workflowSchemeService;
        this.user = user;
        this.scheme = scheme;
    }

    @Override
    WorkflowScheme getScheme() {
        return this.scheme;
    }

    @Override
    WorkflowSchemeBean asBean() {
        return this.beanFactory.asBean(this.scheme, null);
    }

    @Override
    ServiceOutcome<Void> delete() {
        return this.workflowSchemeService.deleteWorkflowScheme(this.user, (WorkflowScheme)this.scheme);
    }

    @Override
    ServiceOutcome<? extends RestWorkflowScheme> update(WorkflowSchemeBean bean) {
        boolean magicDraft;
        AssignableWorkflowScheme.Builder parentBuilder = this.scheme.builder();
        if (bean.isNameSet()) {
            parentBuilder.setName(bean.getName());
        }
        if (bean.isDescriptionSet()) {
            parentBuilder.setDescription(bean.getDescription());
        }
        DraftWorkflowScheme child = (magicDraft = AssignableRestWorkflowScheme.asBoolean(bean.isUpdateDraftIfNeeded())) ? this.getDraft() : null;
        Map<String, String> map = AssignableRestWorkflowScheme.getWorkflowMap((WorkflowScheme)this.scheme, bean);
        if (!(child != null || this.workflowSchemeService.isActive((WorkflowScheme)this.scheme) && !Objects.equal(map, (Object)this.scheme.getMappings()) && magicDraft)) {
            ServiceOutcome parentOutcome = this.workflowSchemeService.updateWorkflowScheme(this.user, ((AssignableWorkflowScheme.Builder)parentBuilder.setMappings(map)).build());
            if (!parentOutcome.isValid()) {
                return ServiceOutcomeImpl.error((ServiceOutcome)parentOutcome);
            }
            this.scheme = (AssignableWorkflowScheme)parentOutcome.getReturnedValue();
            return ServiceOutcomeImpl.ok((Object)this);
        }
        AssignableWorkflowScheme newParent = parentBuilder.build();
        ServiceOutcome validateOutcome = this.workflowSchemeService.validateUpdateWorkflowScheme(this.user, newParent);
        if (!validateOutcome.isValid()) {
            return ServiceOutcomeImpl.error((ServiceOutcome)validateOutcome);
        }
        if (child == null) {
            ServiceOutcome draftSchemeOutcome = this.workflowSchemeService.createDraft(this.user, this.scheme.getId().longValue());
            if (!draftSchemeOutcome.isValid()) {
                return ServiceOutcomeImpl.error((ServiceOutcome)draftSchemeOutcome);
            }
            child = (DraftWorkflowScheme)draftSchemeOutcome.getReturnedValue();
        }
        DraftRestWorkflowScheme draft = this.asDraft(child);
        return draft.update(bean);
    }

    RestWorkflowScheme getDraftMaybe() {
        DraftWorkflowScheme draft = this.getDraft();
        return draft == null ? this : this.asDraft(draft);
    }

    private DraftWorkflowScheme getDraft() {
        ServiceOutcome draftWorkflowScheme = this.workflowSchemeService.getDraftWorkflowScheme(this.user, this.scheme);
        if (!draftWorkflowScheme.isValid() || draftWorkflowScheme.getReturnedValue() == null) {
            return null;
        }
        return (DraftWorkflowScheme)draftWorkflowScheme.getReturnedValue();
    }

    ServiceOutcome<DraftRestWorkflowScheme> getDraftScheme() {
        ServiceOutcome draftWorkflowScheme = this.workflowSchemeService.getDraftWorkflowSchemeNotNull(this.user, this.scheme);
        if (!draftWorkflowScheme.isValid()) {
            return ServiceOutcomeImpl.error((ServiceOutcome)draftWorkflowScheme);
        }
        return ServiceOutcomeImpl.ok((Object)this.asDraft((DraftWorkflowScheme)draftWorkflowScheme.getReturnedValue()));
    }

    ServiceOutcome<DraftRestWorkflowScheme> createDraftScheme() {
        ServiceOutcome draftWorkflowScheme = this.workflowSchemeService.createDraft(this.user, this.scheme.getId().longValue());
        if (!draftWorkflowScheme.isValid()) {
            return ServiceOutcomeImpl.error((ServiceOutcome)draftWorkflowScheme);
        }
        return ServiceOutcomeImpl.ok((Object)this.asDraft((DraftWorkflowScheme)draftWorkflowScheme.getReturnedValue()));
    }

    private DraftRestWorkflowScheme asDraft(DraftWorkflowScheme draft) {
        return new DraftRestWorkflowScheme(this.workflowSchemeService, this.user, this.beanFactory, this.scheme, draft);
    }

    ServiceOutcome<? extends RestWorkflowScheme> updateDraft(WorkflowSchemeBean bean) {
        AssignableWorkflowScheme newParent;
        ServiceOutcome outcome;
        DraftWorkflowScheme child = this.getDraft();
        if (child != null) {
            return this.asDraft(child).update(bean);
        }
        AssignableWorkflowScheme.Builder parentBuilder = this.scheme.builder();
        if (bean.isNameSet()) {
            parentBuilder.setName(bean.getName());
        }
        if (bean.isDescriptionSet()) {
            parentBuilder.setDescription(bean.getDescription());
        }
        if (!(outcome = this.workflowSchemeService.validateUpdateWorkflowScheme(this.user, newParent = parentBuilder.build())).isValid()) {
            return ServiceOutcomeImpl.error((ServiceOutcome)outcome);
        }
        DraftWorkflowScheme.Builder builder = this.workflowSchemeService.draftBuilder(this.scheme);
        builder.setMappings(AssignableRestWorkflowScheme.getWorkflowMap((WorkflowScheme)this.scheme, bean));
        ServiceOutcome draftSchemeOutcome = this.workflowSchemeService.createDraft(this.user, builder.build());
        if (!draftSchemeOutcome.isValid()) {
            return ServiceOutcomeImpl.error((ServiceOutcome)draftSchemeOutcome);
        }
        ServiceOutcome parentOutcome = this.workflowSchemeService.updateWorkflowScheme(this.user, newParent);
        if (!parentOutcome.isValid()) {
            return ServiceOutcomeImpl.error((ServiceOutcome)outcome);
        }
        this.scheme = (AssignableWorkflowScheme)parentOutcome.getReturnedValue();
        return ServiceOutcomeImpl.ok((Object)this.asDraft((DraftWorkflowScheme)draftSchemeOutcome.getReturnedValue()));
    }

    ServiceOutcome<? extends RestWorkflowScheme> deleteWorkflow(final String workflowName, boolean updateDraftIfNeeded) {
        return this.doUpdateMappings(((AssignableWorkflowScheme.Builder)this.scheme.builder().removeWorkflow(workflowName)).build(), updateDraftIfNeeded, new Function<DraftRestWorkflowScheme, ServiceOutcome<? extends RestWorkflowScheme>>(){

            public ServiceOutcome<? extends RestWorkflowScheme> apply(DraftRestWorkflowScheme input) {
                return input.deleteWorkflow(workflowName);
            }
        });
    }

    ServiceOutcome<? extends RestWorkflowScheme> updateWorkflowMappings(final WorkflowMappingBean bean) {
        boolean magicDraft = AssignableRestWorkflowScheme.asBoolean(bean.isUpdateDraftIfNeeded());
        AssignableWorkflowScheme.Builder builder = this.scheme.builder();
        this.mergeWorkflowMappings((WorkflowScheme.Builder<?>)builder, bean);
        return this.doUpdateMappings(builder.build(), magicDraft, new Function<DraftRestWorkflowScheme, ServiceOutcome<? extends RestWorkflowScheme>>(){

            public ServiceOutcome<? extends RestWorkflowScheme> apply(DraftRestWorkflowScheme input) {
                return input.updateWorkflowMappings(bean);
            }
        });
    }

    ServiceOutcome<? extends RestWorkflowScheme> removeIssueType(final String issueType, boolean updateDraftIfNeeded) {
        AssignableWorkflowScheme.Builder builder = this.scheme.builder();
        builder.removeMapping(issueType);
        return this.doUpdateMappings(builder.build(), updateDraftIfNeeded, new Function<DraftRestWorkflowScheme, ServiceOutcome<? extends RestWorkflowScheme>>(){

            public ServiceOutcome<? extends RestWorkflowScheme> apply(DraftRestWorkflowScheme input) {
                return input.removeIssueType(issueType);
            }
        });
    }

    ServiceOutcome<? extends RestWorkflowScheme> updateIssueTypeMappings(final IssueTypeMappingBean bean) {
        boolean magicDraft = AssignableRestWorkflowScheme.asBoolean(bean.getUpdateDraftIfNeeded());
        AssignableWorkflowScheme.Builder builder = this.scheme.builder();
        this.mergeIssueTypeMapping((WorkflowScheme.Builder<?>)builder, bean);
        return this.doUpdateMappings(builder.build(), magicDraft, new Function<DraftRestWorkflowScheme, ServiceOutcome<? extends RestWorkflowScheme>>(){

            public ServiceOutcome<? extends RestWorkflowScheme> apply(DraftRestWorkflowScheme input) {
                return input.updateIssueTypeMappings(bean);
            }
        });
    }

    ServiceOutcome<? extends RestWorkflowScheme> removeDefault(boolean updateDraftIfNeeded) {
        AssignableWorkflowScheme newScheme = ((AssignableWorkflowScheme.Builder)this.scheme.builder().removeDefault()).build();
        return this.doUpdateMappings(newScheme, updateDraftIfNeeded, new Function<DraftRestWorkflowScheme, ServiceOutcome<? extends RestWorkflowScheme>>(){

            public ServiceOutcome<? extends RestWorkflowScheme> apply(DraftRestWorkflowScheme input) {
                return input.removeDefault();
            }
        });
    }

    ServiceOutcome<? extends RestWorkflowScheme> updateDefault(final DefaultBean bean) {
        AssignableWorkflowScheme.Builder builder = this.scheme.builder();
        AssignableRestWorkflowScheme.setDefaultMapping(builder, bean);
        boolean magicDraft = AssignableRestWorkflowScheme.asBoolean(bean.getUpdateDraftIfNeeded());
        return this.doUpdateMappings(builder.build(), magicDraft, new Function<DraftRestWorkflowScheme, ServiceOutcome<? extends RestWorkflowScheme>>(){

            public ServiceOutcome<? extends RestWorkflowScheme> apply(DraftRestWorkflowScheme input) {
                return input.updateDefault(bean);
            }
        });
    }

    private ServiceOutcome<? extends RestWorkflowScheme> doUpdateMappings(AssignableWorkflowScheme newScheme, boolean updateDraftIfNeeded, Function<DraftRestWorkflowScheme, ServiceOutcome<? extends RestWorkflowScheme>> draftUpdateFunction) {
        DraftWorkflowScheme child;
        DraftWorkflowScheme draftWorkflowScheme = child = updateDraftIfNeeded ? this.getDraft() : null;
        if (child != null) {
            return (ServiceOutcome)draftUpdateFunction.apply((Object)this.asDraft(child));
        }
        if (((Object)this.scheme.getMappings()).equals(newScheme.getMappings())) {
            return ServiceOutcomeImpl.ok((Object)this);
        }
        if (!this.workflowSchemeService.isActive((WorkflowScheme)this.scheme) || !updateDraftIfNeeded) {
            ServiceOutcome parentOutcome = this.workflowSchemeService.updateWorkflowScheme(this.user, newScheme);
            if (!parentOutcome.isValid()) {
                return ServiceOutcomeImpl.error((ServiceOutcome)parentOutcome);
            }
            this.scheme = (AssignableWorkflowScheme)parentOutcome.getReturnedValue();
            return ServiceOutcomeImpl.ok((Object)this);
        }
        ServiceOutcome draftSchemeOutcome = this.workflowSchemeService.createDraft(this.user, this.scheme.getId().longValue());
        if (!draftSchemeOutcome.isValid()) {
            return ServiceOutcomeImpl.error((ServiceOutcome)draftSchemeOutcome);
        }
        child = (DraftWorkflowScheme)draftSchemeOutcome.getReturnedValue();
        return (ServiceOutcome)draftUpdateFunction.apply((Object)this.asDraft(child));
    }

    public static class Factory {
        private final WorkflowSchemeService workflowSchemeService;
        private final JiraAuthenticationContext jac;
        private final WorkflowSchemeBeanFactory beanFactory;

        public Factory(WorkflowSchemeService workflowSchemeService, JiraAuthenticationContext jac, WorkflowSchemeBeanFactory beanFactory) {
            this.workflowSchemeService = workflowSchemeService;
            this.jac = jac;
            this.beanFactory = beanFactory;
        }

        ServiceOutcome<AssignableRestWorkflowScheme> getById(long id) {
            ApplicationUser user = this.getUser();
            return this.respone(user, (ServiceOutcome<AssignableWorkflowScheme>)this.workflowSchemeService.getWorkflowScheme(user, id));
        }

        ServiceOutcome<AssignableRestWorkflowScheme> create(WorkflowSchemeBean bean) {
            AssignableWorkflowScheme.Builder builder = this.workflowSchemeService.assignableBuilder();
            builder.setName(bean.getName());
            builder.setDescription(bean.getDescription());
            builder.setMappings(RestWorkflowScheme.getWorkflowMap(null, bean));
            ApplicationUser user = this.getUser();
            return this.respone(user, (ServiceOutcome<AssignableWorkflowScheme>)this.workflowSchemeService.createScheme(user, builder.build()));
        }

        private ServiceOutcome<AssignableRestWorkflowScheme> respone(ApplicationUser user, ServiceOutcome<AssignableWorkflowScheme> workflowScheme) {
            if (workflowScheme.isValid()) {
                return ServiceOutcomeImpl.ok((Object)new AssignableRestWorkflowScheme(this.workflowSchemeService, user, this.beanFactory, (AssignableWorkflowScheme)workflowScheme.getReturnedValue()));
            }
            return ServiceOutcomeImpl.error(workflowScheme);
        }

        private ApplicationUser getUser() {
            return ApplicationUsers.from((User)this.jac.getLoggedInUser());
        }
    }
}

