/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.auditing;

import com.atlassian.jira.auditing.AuditingManager;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.ForbiddenWebException;
import com.atlassian.jira.rest.v2.admin.auditing.SettingsBean;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="auditing/settings")
@WebSudoRequired
public class SettingsResource {
    private final AuditingManager auditingManager;
    private final I18nHelper i18n;

    public SettingsResource(AuditingManager auditingManager, I18nHelper i18n) {
        this.auditingManager = auditingManager;
        this.i18n = i18n;
    }

    @GET
    public Response settings() {
        return Response.ok((Object)new SettingsBean(this.auditingManager.isAuditingEnabled())).build();
    }

    @PUT
    public Response saveSettings(SettingsBean settings) {
        try {
            this.auditingManager.setAuditingEnabled(settings.isEnabled());
            return this.settings();
        }
        catch (PermissionException e) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("error.no-permission")));
        }
    }
}

