/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.issue.fields.ColumnService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.BadRequestWebException;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.search.ColumnOptions;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.UrlValidator;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="settings")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SettingsResource {
    private final ApplicationProperties applicationProperties;
    private final ColumnService columnService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final I18nHelper i18n;

    public SettingsResource(ApplicationProperties applicationProperties, ColumnService columnService, JiraAuthenticationContext jiraAuthenticationContext, GlobalPermissionManager globalPermissionManager, I18nHelper i18n) {
        this.applicationProperties = applicationProperties;
        this.columnService = columnService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.globalPermissionManager = globalPermissionManager;
        this.i18n = i18n;
    }

    @GET
    @Path(value="columns")
    public Response getIssueNavigatorDefaultColumns() {
        ApplicationUser currentUser = this.jiraAuthenticationContext.getUser();
        ServiceOutcome outcome = this.columnService.getDefaultColumnLayout(currentUser);
        if (outcome.isValid()) {
            List columnLayoutItems = ((ColumnLayout)outcome.getReturnedValue()).getColumnLayoutItems();
            return Response.ok(ColumnOptions.toColumnOptions(columnLayoutItems)).cacheControl(CacheControl.never()).build();
        }
        throw new RESTException(ErrorCollection.of(outcome.getErrorCollection()));
    }

    @PUT
    @Path(value="columns")
    @Consumes(value={"*/*"})
    public Response setIssueNavigatorDefaultColumns(@FormParam(value="columns") List<String> fields) {
        ApplicationUser currentUser = this.jiraAuthenticationContext.getUser();
        ServiceResult outcome = this.columnService.setDefaultColumns(currentUser, fields);
        if (outcome.isValid()) {
            return Response.ok().cacheControl(CacheControl.never()).build();
        }
        throw new RESTException(ErrorCollection.of(outcome.getErrorCollection()));
    }

    @PUT
    @AnonymousAllowed
    @Path(value="baseUrl")
    public void setBaseURL(String baseURL) {
        if (!this.isSysAdmin(this.jiraAuthenticationContext.getLoggedInUser())) {
            throw new NotAuthorisedWebException(ErrorCollection.of(this.i18n.getText("rest.settings.baseurl.permission.denied")));
        }
        if (!UrlValidator.isValid((String)baseURL)) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("rest.settings.baseurl.invalid")));
        }
        this.applicationProperties.setString("jira.baseurl", baseURL);
    }

    private boolean isSysAdmin(User currentUser) {
        return currentUser != null && this.globalPermissionManager.hasPermission(44, currentUser);
    }
}

