/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.rest.v2.ServerInfoBean;
import com.atlassian.jira.rest.v2.healthcheck.ValidationQuery;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.CorsAllowed;
import java.util.Collections;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="serverInfo")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@CorsAllowed
public class ServerInfoResource {
    private final ApplicationProperties properties;
    private final BuildUtilsInfo buildUtils;
    private final JiraAuthenticationContext authContext;
    private final PermissionManager permissionManager;
    private final OfBizDelegator ofBizDelegator;

    public ServerInfoResource(ApplicationProperties properties, BuildUtilsInfo buildUtils, JiraAuthenticationContext authContext, PermissionManager permissionManager, OfBizDelegator ofBizDelegator) {
        this.properties = properties;
        this.buildUtils = buildUtils;
        this.authContext = authContext;
        this.permissionManager = permissionManager;
        this.ofBizDelegator = ofBizDelegator;
    }

    @GET
    public ServerInfoBean getServerInfo(@Deprecated @QueryParam(value="doHealthCheck") boolean doHealthCheck) {
        ServerInfoBean serverInfo = this.createServerInfoBean();
        if (doHealthCheck) {
            this.addHealthCheckInfo(serverInfo);
        }
        return serverInfo;
    }

    private ServerInfoBean createServerInfoBean() {
        boolean canUse = this.permissionManager.hasPermission(1, this.authContext.getLoggedInUser());
        return new ServerInfoBean(this.properties.getString("jira.baseurl"), this.buildUtils.getVersion(), this.buildUtils.getVersionNumbers(), Integer.valueOf(this.buildUtils.getCurrentBuildNumber()), this.buildUtils.getCurrentBuildDate(), this.buildUtils.getCommitId(), this.buildUtils.getBuildPartnerName(), this.properties.getString("jira.title"), canUse ? new Date() : null);
    }

    @Deprecated
    private void addHealthCheckInfo(ServerInfoBean serverInfo) {
        serverInfo.healthChecks = Collections.singletonList(new ValidationQuery(this.ofBizDelegator).doCheck());
    }
}

