/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.renderers;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.CorsAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@Path(value="render")
@AnonymousAllowed
@Consumes(value={"application/json", "application/x-www-form-urlencoded"})
@Produces(value={"text/html"})
@CorsAllowed
public class RenderersResource {
    private static final String NBSP = "&nbsp;";
    private final RendererManager rendererManager;
    private final IssueManager issueManager;
    private final ProjectManager projectManager;
    private final IssueFactory issueFactory;
    private final ConstantsManager constantsManager;

    public RenderersResource(RendererManager rendererManager, IssueManager issueManager, ProjectManager projectManager, IssueFactory issueFactory, ConstantsManager constantsManager) {
        this.rendererManager = rendererManager;
        this.issueManager = issueManager;
        this.projectManager = projectManager;
        this.issueFactory = issueFactory;
        this.constantsManager = constantsManager;
    }

    @POST
    public Response getRenderedContent(ContentToRender contentToRender) {
        String content = this.getPreviewHtml(contentToRender.rendererType, contentToRender.unrenderedMarkup, contentToRender.issueKey, contentToRender.projectId, contentToRender.issueType);
        return Response.ok((Object)content).cacheControl(CacheControl.NO_CACHE).build();
    }

    public String getPreviewHtml(String rendererType, String unrenderedMarkup, String issueKey, String projectId, String issueType) {
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        if (issue != null) {
            return this.doGetPreviewHtml(rendererType, unrenderedMarkup, issue.getIssueRenderContext());
        }
        if (StringUtils.isEmpty((String)projectId) || StringUtils.isEmpty((String)issueType)) {
            return this.doGetPreviewHtml(rendererType, unrenderedMarkup, null);
        }
        IssueRenderContext renderContext = this.generateRenderContext(projectId, issueType);
        return this.doGetPreviewHtml(rendererType, unrenderedMarkup, renderContext);
    }

    private IssueRenderContext generateRenderContext(String projectId, String issueType) {
        Project projectObj;
        try {
            projectObj = this.projectManager.getProjectObj(Long.valueOf(projectId));
            if (projectObj == null) {
                return null;
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        MutableIssue issue = this.issueFactory.getIssue();
        issue.setProjectObject(projectObj);
        if (this.constantsManager.getIssueTypeObject(issueType) != null) {
            issue.setIssueTypeId(issueType);
        }
        IssueRenderContext renderContext = new IssueRenderContext((Issue)issue);
        renderContext.addParam((Object)"jira.issue", (Object)issue);
        return renderContext;
    }

    private String doGetPreviewHtml(String rendererType, String unrenderedMarkup, IssueRenderContext renderContext) {
        String result = this.rendererManager.getRenderedContent(rendererType, unrenderedMarkup, renderContext);
        return StringUtils.isBlank((String)result) ? NBSP : result;
    }

    @XmlRootElement
    public static class ContentToRender {
        @XmlElement
        private String rendererType;
        @XmlElement
        private String unrenderedMarkup;
        @XmlElement
        private String issueKey;
        @XmlElement
        private String projectId;
        @XmlElement
        private String issueType;

        public ContentToRender() {
        }

        public ContentToRender(String rendererType, String unrenderedMarkup, String issueKey, String projectId, String issueType) {
            this.rendererType = rendererType;
            this.unrenderedMarkup = unrenderedMarkup;
            this.issueKey = issueKey;
            this.projectId = projectId;
            this.issueType = issueType;
        }
    }
}

