/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.menus;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.CorsAllowed;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="menus")
@AnonymousAllowed
@Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
@Produces(value={"application/json", "application/xml"})
@CorsAllowed
public class MenuResource {
    private final SimpleLinkManager simpleLinkManager;
    private final JiraAuthenticationContext authenticationContext;
    private final UserProjectHistoryManager userProjectHistoryManager;

    public MenuResource(SimpleLinkManager simpleLinkManager, JiraAuthenticationContext authenticationContext, UserProjectHistoryManager userProjectHistoryManager) {
        this.simpleLinkManager = simpleLinkManager;
        this.authenticationContext = authenticationContext;
        this.userProjectHistoryManager = userProjectHistoryManager;
    }

    @GET
    @Path(value="{location}")
    public Response getMenuList(@Context HttpServletRequest request, @PathParam(value="location") String location, @QueryParam(value="inAdminMode") Boolean inAdminMode) {
        User user = this.authenticationContext.getLoggedInUser();
        Project selectedProject = this.userProjectHistoryManager.getCurrentProject(10, user);
        JiraHelper jiraHelper = new JiraHelper(request, selectedProject);
        List sections = this.simpleLinkManager.getSectionsForLocation(location, user, jiraHelper);
        if (inAdminMode.booleanValue()) {
            request.setAttribute("jira.admin.mode", (Object)true);
        }
        ArrayList<Section> returnedList = new ArrayList<Section>(sections.size());
        for (SimpleLinkSection section : sections) {
            List links = this.simpleLinkManager.getLinksForSection(location + "/" + section.getId(), user, jiraHelper);
            ArrayList<Link> returnLinks = new ArrayList<Link>(links.size());
            for (SimpleLink link : links) {
                returnLinks.add(new Link(link));
            }
            Section newSection = new Section(section, returnLinks);
            returnedList.add(newSection);
        }
        return Response.ok((Object)new Menu(returnedList)).cacheControl(CacheControl.NO_CACHE).build();
    }

    @XmlRootElement
    public static class Link {
        @XmlElement
        private String label;
        @XmlElement
        private String title;
        @XmlElement
        private String iconUrl;
        @XmlElement
        private String style;
        @XmlElement
        private String id;
        @XmlElement
        private String url;
        @XmlElement
        private Map<String, String> parameters;

        private Link() {
        }

        public Link(SimpleLink link) {
            this.label = link.getLabel();
            this.title = link.getTitle();
            this.iconUrl = link.getIconUrl();
            this.style = link.getStyleClass();
            this.id = link.getId();
            this.url = link.getUrl();
            this.parameters = link.getParams();
        }
    }

    @XmlRootElement
    public static class Section {
        @XmlElement
        private String label;
        @XmlElement
        private String title;
        @XmlElement
        private String iconUrl;
        @XmlElement
        private String style;
        @XmlElement
        private String id;
        @XmlElement
        List<Link> items;

        private Section() {
        }

        public Section(SimpleLinkSection section, List<Link> items) {
            this.items = items;
            this.label = section.getLabel();
            this.title = section.getTitle();
            this.iconUrl = section.getIconUrl();
            this.style = section.getStyleClass();
            this.id = section.getId();
        }
    }

    @XmlRootElement
    public static class Menu {
        @XmlElement
        private List<Section> sections;

        private Menu() {
        }

        public Menu(List<Section> sections) {
            this.sections = sections;
        }
    }
}

