/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.jql;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.ValueGeneratingClauseHandler;
import com.atlassian.jira.jql.operand.registry.PredicateRegistry;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.DelimeterInserter;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.CorsAllowed;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="jql/autocomplete")
@AnonymousAllowed
@Produces(value={"application/json", "application/xml"})
@CorsAllowed
public class AutoCompleteResource {
    private final SearchHandlerManager searchHandlerManager;
    private final JiraAuthenticationContext authenticationContext;
    private final JqlStringSupport jqlStringSupport;
    private final PredicateRegistry predicateRegistry;

    public AutoCompleteResource(JiraAuthenticationContext authenticationContext, JqlStringSupport jqlStringSupport, SearchHandlerManager searchHandlerManager, PredicateRegistry predicateRegistry) {
        this.searchHandlerManager = searchHandlerManager;
        this.authenticationContext = authenticationContext;
        this.jqlStringSupport = jqlStringSupport;
        this.predicateRegistry = predicateRegistry;
    }

    @GET
    public Response getIssuesResponse(@QueryParam(value="fieldName") String fieldName, @QueryParam(value="fieldValue") String fieldValue, @QueryParam(value="predicateName") String predicateName, @QueryParam(value="predicateValue") String predicateValue) {
        AutoCompleteResultsWrapper results = new AutoCompleteResultsWrapper();
        if (fieldValue != null) {
            this.getAutoCompleteResultsForField(fieldName, fieldValue, results);
        }
        if (predicateName != null) {
            this.getAutoCompleteResultsForPredicate(predicateName, predicateValue, fieldName, results);
        }
        return Response.ok((Object)results).cacheControl(CacheControl.NO_CACHE).build();
    }

    private void getAutoCompleteResultsForPredicate(String predicateName, String predicateValue, String fieldName, AutoCompleteResultsWrapper results) {
        User searcher = this.authenticationContext.getLoggedInUser();
        ClauseValuesGenerator clauseValuesGenerator = this.predicateRegistry.getClauseValuesGenerator(predicateName, fieldName);
        this.generateResults(clauseValuesGenerator, searcher, predicateName, predicateValue, results);
    }

    private void getAutoCompleteResultsForField(String fieldName, String fieldValue, AutoCompleteResultsWrapper results) {
        ClauseHandler clauseHandler;
        User searcher = this.authenticationContext.getLoggedInUser();
        Collection clauseHandlers = this.searchHandlerManager.getClauseHandler(searcher, fieldName);
        if (clauseHandlers != null && clauseHandlers.size() == 1 && (clauseHandler = (ClauseHandler)clauseHandlers.iterator().next()) instanceof ValueGeneratingClauseHandler) {
            ClauseValuesGenerator clauseValuesGenerator = ((ValueGeneratingClauseHandler)clauseHandler).getClauseValuesGenerator();
            this.generateResults(clauseValuesGenerator, searcher, fieldName, fieldValue, results);
        }
    }

    private String quoteZeroPaddedNumbers(String value) {
        if (value == null) {
            return value;
        }
        try {
            long longVal = Long.parseLong(value);
            if (value.startsWith("0")) {
                return "\"" + value + "\"";
            }
            return value;
        }
        catch (NumberFormatException nfe) {
            return value;
        }
    }

    private void generateResults(ClauseValuesGenerator clauseValuesGenerator, User searcher, String fieldName, String fieldValue, AutoCompleteResultsWrapper results) {
        DelimeterInserter delimeterInserter = new DelimeterInserter("<b>", "</b>");
        delimeterInserter.setConsideredWhitespace("-_/\\,.+=&^%$#*@!~`'\":;<>(");
        ClauseValuesGenerator.Results generatorResults = clauseValuesGenerator.getPossibleValues(searcher, fieldName, fieldValue, 15);
        List list = generatorResults.getResults();
        for (ClauseValuesGenerator.Result result : list) {
            StringBuilder displayName = new StringBuilder();
            for (int i = 0; i < result.getDisplayNameParts().length; ++i) {
                if (i != 0) {
                    displayName.append(" ");
                }
                String displayNamePart = result.getDisplayNameParts()[i];
                displayName.append(delimeterInserter.insert(TextUtils.htmlEncode((String)displayNamePart), new String[]{TextUtils.htmlEncode((String)fieldValue)}));
            }
            String encodedValue = this.jqlStringSupport.encodeValue(result.getValue());
            results.addResult(new AutoCompleteResult(this.quoteZeroPaddedNumbers(encodedValue), displayName.toString()));
        }
    }

    @XmlRootElement
    public static class AutoCompleteResult {
        @XmlElement
        private String value;
        @XmlElement
        private String displayName;

        private AutoCompleteResult() {
        }

        public AutoCompleteResult(String value, String displayName) {
            this.value = value;
            this.displayName = displayName;
        }
    }

    @XmlRootElement
    public static class AutoCompleteResultsWrapper {
        @XmlElement
        private List<AutoCompleteResult> results = new ArrayList<AutoCompleteResult>();

        private AutoCompleteResultsWrapper() {
        }

        public void addResult(AutoCompleteResult result) {
            this.results.add(result);
        }
    }
}

