/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.issues;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.search.IssuePickerSearchService;
import com.atlassian.jira.bc.issue.vote.VoteService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.v1.issues.IssueActionsAndOperationsResource;
import com.atlassian.jira.rest.v1.issues.IssuePickerResource;
import com.atlassian.jira.rest.v1.model.errors.ErrorCollection;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="issues")
@AnonymousAllowed
@Consumes(value={"application/json", "application/xml"})
@Produces(value={"application/json", "application/xml"})
public class IssueResource {
    private final JiraAuthenticationContext authContext;
    private final I18nHelper i18n;
    private final IssuePickerSearchService service;
    private final IssueManager issueManager;
    private final IssueService issueService;
    private final ApplicationProperties applicationProperties;
    private final ProjectManager projectManager;
    private final SimpleLinkManager simpleLinkManager;
    private final XsrfTokenGenerator xsrfTokenGenerator;
    private final VoteService voteService;
    private final WatcherManager watcherManager;
    private final IssueWorkflowManager issueWorkflowManager;

    public IssueResource(JiraAuthenticationContext authContext, I18nHelper i18n, IssuePickerSearchService service, IssueManager issueManager, IssueService issueService, ApplicationProperties applicationProperties, ProjectManager projectManager, SimpleLinkManager simpleLinkManager, XsrfTokenGenerator xsrfTokenGenerator, VoteService voteService, WatcherManager watcherManager, IssueWorkflowManager issueWorkflowManager) {
        this.authContext = authContext;
        this.i18n = i18n;
        this.service = service;
        this.issueManager = issueManager;
        this.issueService = issueService;
        this.applicationProperties = applicationProperties;
        this.projectManager = projectManager;
        this.simpleLinkManager = simpleLinkManager;
        this.xsrfTokenGenerator = xsrfTokenGenerator;
        this.voteService = voteService;
        this.watcherManager = watcherManager;
        this.issueWorkflowManager = issueWorkflowManager;
    }

    @Path(value="picker")
    public IssuePickerResource getIssuePickerResource() {
        return new IssuePickerResource(this.authContext, this.i18n, this.service, this.issueManager, this.applicationProperties, this.projectManager);
    }

    @Path(value="{issueId}/ActionsAndOperations")
    public IssueActionsAndOperationsResource getActionsAndOperationsResource(@PathParam(value="issueId") String issueId) {
        return new IssueActionsAndOperationsResource(this.authContext, this.issueManager, this.i18n, issueId, this.simpleLinkManager, this.xsrfTokenGenerator, this.issueWorkflowManager);
    }

    @POST
    @Path(value="{issueId}/voters")
    public Response addVoter(@PathParam(value="issueId") Long issueId) {
        User user = this.authContext.getLoggedInUser();
        if (this.notAuthenticatedRequest(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(CacheControl.NO_CACHE).build();
        }
        IssueService.IssueResult result = this.issueService.getIssue(user, issueId);
        if (result.getIssue() == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.NO_CACHE).build();
        }
        VoteService.VoteValidationResult validationResult = this.voteService.validateAddVote(user, user, (Issue)result.getIssue());
        if (validationResult.isValid()) {
            int votes = this.voteService.addVote(user, validationResult);
            return Response.ok((Object)new VoteWatchResult(votes)).cacheControl(CacheControl.NO_CACHE).build();
        }
        ErrorCollection errors = ErrorCollection.Builder.newBuilder().addErrorCollection(validationResult.getErrorCollection()).build();
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).cacheControl(CacheControl.NO_CACHE).build();
    }

    @DELETE
    @Path(value="{issueId}/voters")
    public Response removeVoter(@PathParam(value="issueId") Long issueId) {
        User user = this.authContext.getLoggedInUser();
        if (this.notAuthenticatedRequest(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(CacheControl.NO_CACHE).build();
        }
        IssueService.IssueResult result = this.issueService.getIssue(user, issueId);
        if (result.getIssue() == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.NO_CACHE).build();
        }
        VoteService.VoteValidationResult validationResult = this.voteService.validateRemoveVote(user, user, (Issue)result.getIssue());
        if (validationResult.isValid()) {
            int votes = this.voteService.removeVote(user, validationResult);
            return Response.ok((Object)new VoteWatchResult(votes)).cacheControl(CacheControl.NO_CACHE).build();
        }
        ErrorCollection errors = ErrorCollection.Builder.newBuilder().addErrorCollection(validationResult.getErrorCollection()).build();
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).cacheControl(CacheControl.NO_CACHE).build();
    }

    @POST
    @Path(value="{issueId}/watchers")
    public Response addWatcher(@PathParam(value="issueId") Long issueId) {
        User user = this.authContext.getLoggedInUser();
        if (this.notAuthenticatedRequest(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(CacheControl.NO_CACHE).build();
        }
        IssueService.IssueResult result = this.issueService.getIssue(user, issueId);
        if (result.getIssue() == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.NO_CACHE).build();
        }
        if (!this.watcherManager.isWatchingEnabled() || this.notAuthenticatedRequest(user)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.NO_CACHE).build();
        }
        this.watcherManager.startWatching(user, (Issue)result.getIssue());
        int watcherCount = this.watcherManager.getWatcherCount((Issue)result.getIssue());
        return Response.ok((Object)new VoteWatchResult(watcherCount)).cacheControl(CacheControl.NO_CACHE).build();
    }

    @DELETE
    @Path(value="{issueId}/watchers")
    public Response removeWatcher(@PathParam(value="issueId") Long issueId) {
        User user = this.authContext.getLoggedInUser();
        if (this.notAuthenticatedRequest(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(CacheControl.NO_CACHE).build();
        }
        IssueService.IssueResult result = this.issueService.getIssue(user, issueId);
        if (result.getIssue() == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.NO_CACHE).build();
        }
        if (!this.watcherManager.isWatchingEnabled()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.NO_CACHE).build();
        }
        this.watcherManager.stopWatching(user, (Issue)result.getIssue());
        int watcherCount = this.watcherManager.getWatcherCount((Issue)result.getIssue());
        return Response.ok((Object)new VoteWatchResult(watcherCount)).cacheControl(CacheControl.NO_CACHE).build();
    }

    private boolean notAuthenticatedRequest(User user) {
        return user == null;
    }

    @XmlRootElement
    public static class VoteWatchResult {
        @XmlElement
        private int count = 0;

        private VoteWatchResult() {
        }

        public VoteWatchResult(int count) {
            this.count = count;
        }

        public int voteCount() {
            return this.count;
        }
    }
}

