/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.issues;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.search.IssuePickerResults;
import com.atlassian.jira.bc.issue.search.IssuePickerSearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.DelimeterInserter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@AnonymousAllowed
@Produces(value={"application/json", "application/xml"})
public class IssuePickerResource {
    private static final Logger log = Logger.getLogger(IssuePickerResource.class);
    private final JiraAuthenticationContext authContext;
    private final IssuePickerSearchService service;
    private final IssueManager issueManager;
    private final ApplicationProperties applicationProperties;
    private final ProjectManager projectManager;
    private final I18nHelper i18nHelper;

    public IssuePickerResource(JiraAuthenticationContext authContext, I18nHelper i18nHelper, IssuePickerSearchService service, IssueManager issueManager, ApplicationProperties applicationProperties, ProjectManager projectManager) {
        this.authContext = authContext;
        this.service = service;
        this.issueManager = issueManager;
        this.applicationProperties = applicationProperties;
        this.projectManager = projectManager;
        this.i18nHelper = i18nHelper;
    }

    @GET
    public Response getIssuesResponse(@QueryParam(value="query") String query, @QueryParam(value="currentJQL") String currentJQL, @QueryParam(value="currentIssueKey") String currentIssueKey, @QueryParam(value="currentProjectId") String currentProjectId, @QueryParam(value="showSubTasks") boolean showSubTasks, @QueryParam(value="showSubTaskParent") boolean showSubTaskParent) {
        if (query == null || StringUtils.isEmpty((String)query)) {
            currentJQL = null;
        }
        return Response.ok((Object)this.getIssues(query, currentJQL, currentIssueKey, currentProjectId, showSubTasks, showSubTaskParent)).cacheControl(CacheControl.NO_CACHE).build();
    }

    public IssuePickerResultsWrapper getIssues(String query, String currentJQL, String currentIssueKey, String currentProjectId, boolean showSubTasks, boolean showSubTaskParent) {
        JiraServiceContext context = this.getContext();
        IssuePickerResultsWrapper results = new IssuePickerResultsWrapper();
        MutableIssue currentIssue = null;
        if (TextUtils.stringSet((String)currentIssueKey)) {
            currentIssue = this.issueManager.getIssueObject(currentIssueKey);
        }
        int limit = this.getLimit();
        Project project = null;
        if (TextUtils.stringSet((String)currentProjectId)) {
            project = this.projectManager.getProjectObj(new Long(currentProjectId));
        }
        IssuePickerSearchService.IssuePickerParameters pickerParameters = new IssuePickerSearchService.IssuePickerParameters(query, currentJQL, (Issue)currentIssue, project, showSubTasks, showSubTaskParent, limit);
        Collection pickerResults = this.service.getResults(context, pickerParameters);
        for (IssuePickerResults pickerResult : pickerResults) {
            IssueSection section;
            Collection issues = pickerResult.getIssues();
            String labelKey = pickerResult.getLabel();
            String id = pickerResult.getId();
            String label = this.i18nHelper.getText(labelKey);
            if (!issues.isEmpty()) {
                section = new IssueSection(id, label, this.i18nHelper.getText("jira.ajax.autocomplete.showing.x.of.y", Integer.toString(issues.size()), Integer.toString(pickerResult.getTotalIssues())), null);
                results.addSection(section);
                for (Issue issue : issues) {
                    section.addIssue(this.getIssue(issue, pickerResult));
                }
                continue;
            }
            section = new IssueSection(id, label, null, this.i18nHelper.getText("jira.ajax.autocomplete.no.matching.issues"));
            results.addSection(section);
        }
        return results;
    }

    private int getLimit() {
        int limit = 20;
        try {
            limit = Integer.valueOf(this.applicationProperties.getDefaultBackedString("jira.ajax.autocomplete.limit"));
        }
        catch (NumberFormatException nfe) {
            log.error((Object)"jira.ajax.autocomplete.limit does not exist or is an invalid number in jira-application.properties.", (Throwable)nfe);
        }
        return limit;
    }

    private IssuePickerIssue getIssue(Issue issue, IssuePickerResults result) {
        DelimeterInserter delimeterInserter = new DelimeterInserter("<b>", "</b>");
        delimeterInserter.setConsideredWhitespace("-_/\\,.+=&^%$#*@!~`'\":;<>");
        String[] keysTerms = result.getKeyTerms().toArray(new String[result.getKeyTerms().size()]);
        String[] summaryTerms = result.getSummaryTerms().toArray(new String[result.getSummaryTerms().size()]);
        String issueKey = delimeterInserter.insert(TextUtils.htmlEncode((String)issue.getKey()), keysTerms);
        String issueSummary = delimeterInserter.insert(TextUtils.htmlEncode((String)issue.getSummary()), summaryTerms);
        return new IssuePickerIssue(issue.getKey(), issueKey, this.getIconURI((IssueConstant)issue.getIssueTypeObject()), issueSummary, issue.getSummary());
    }

    private String getIconURI(IssueConstant issueConstant) {
        if (issueConstant == null) {
            return "";
        }
        return issueConstant.getIconUrl();
    }

    protected JiraServiceContext getContext() {
        User user = this.authContext.getLoggedInUser();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        return new JiraServiceContextImpl(user, (ErrorCollection)errorCollection);
    }

    @XmlRootElement
    public static class IssuePickerIssue {
        @XmlElement
        private String key;
        @XmlElement
        private String keyHtml;
        @XmlElement
        private String img;
        @XmlElement
        private String summary;
        @XmlElement
        private String summaryText;

        private IssuePickerIssue() {
        }

        public IssuePickerIssue(String key, String keyHtml, String img, String summary, String summaryText) {
            this.key = key;
            this.keyHtml = keyHtml;
            this.img = img;
            this.summary = summary;
            this.summaryText = summaryText;
        }
    }

    @XmlRootElement
    public static class IssueSection {
        @XmlElement
        private String label;
        @XmlElement
        private String sub;
        @XmlElement
        private String id;
        @XmlElement
        private String msg;
        @XmlElement
        private List<IssuePickerIssue> issues = null;

        private IssueSection() {
        }

        public IssueSection(String id, String label, String sub, String msg, List<IssuePickerIssue> issues) {
            this.label = label;
            this.sub = sub;
            this.id = id;
            this.issues = issues;
            this.msg = msg;
        }

        public IssueSection(String id, String label, String sub, String msg) {
            this.label = label;
            this.sub = sub;
            this.id = id;
            this.msg = msg;
        }

        public void addIssue(IssuePickerIssue issue) {
            if (this.issues == null) {
                this.issues = new ArrayList<IssuePickerIssue>();
            }
            this.issues.add(issue);
        }
    }

    @XmlRootElement
    public static class IssuePickerResultsWrapper {
        @XmlElement
        private List<IssueSection> sections = null;

        private IssuePickerResultsWrapper() {
        }

        public IssuePickerResultsWrapper(List<IssueSection> sections) {
            this.sections = sections;
        }

        public void addSection(IssueSection section) {
            if (this.sections == null) {
                this.sections = new ArrayList<IssueSection>();
            }
            this.sections.add(section);
        }
    }
}

