/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.images;

import com.atlassian.jira.image.dropdown.DropDownCreatorService;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.CorsAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="dropdowns")
@AnonymousAllowed
@Produces(value={"image/png"})
@CorsAllowed
public class DropDownResource {
    private final DropDownCreatorService dropDownCreatorService;

    public DropDownResource(DropDownCreatorService dropDownCreatorService) {
        this.dropDownCreatorService = dropDownCreatorService;
    }

    @GET
    public Response getImage(@QueryParam(value="color") String colorHex, @QueryParam(value="bgcolor") String backgroundColorHex) {
        byte[] dropdown = this.dropDownCreatorService.getDropdown(colorHex, backgroundColorHex);
        return Response.ok((Object)dropdown).cacheControl(CacheControl.CACHE_FOREVER).build();
    }

    @GET
    @Path(value="/{hash}/{color}/{bgcolor}/img.png")
    public Response getImageFromPath(@PathParam(value="color") String colorHex, @PathParam(value="bgcolor") String backgroundColorHex) {
        return this.getImage(colorHex, backgroundColorHex);
    }
}

