/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.attachment;

import com.atlassian.core.util.FileSize;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.TemporaryAttachment;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.util.AttachmentHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.user.SecureUserTokenManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.util.AttachmentException;
import com.atlassian.jira.web.util.WebAttachmentManager;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.CorsAllowed;
import java.io.InputStream;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.io.IOUtils;
import webwork.config.Configuration;

@Path(value="AttachTemporaryFile")
@Produces(value={"application/json"})
@AnonymousAllowed
@CorsAllowed
public class AttachTemporaryFileResource {
    private final JiraAuthenticationContext authContext;
    private final WebAttachmentManager webAttachmentManager;
    private final IssueService issueService;
    private final ProjectService projectService;
    private final XsrfTokenGenerator xsrfGenerator;
    private final AttachmentHelper attachmentHelper;
    private final SecureUserTokenManager secureUserTokenManager;

    public AttachTemporaryFileResource(JiraAuthenticationContext authContext, WebAttachmentManager webAttachmentManager, IssueService issueService, ProjectService projectService, XsrfTokenGenerator xsrfGenerator, AttachmentHelper attachmentHelper, SecureUserTokenManager secureUserTokenManager) {
        this.authContext = authContext;
        this.webAttachmentManager = webAttachmentManager;
        this.issueService = issueService;
        this.projectService = projectService;
        this.xsrfGenerator = xsrfGenerator;
        this.attachmentHelper = attachmentHelper;
        this.secureUserTokenManager = secureUserTokenManager;
    }

    @POST
    @Consumes(value={"*/*"})
    @Path(value="/secure")
    public Response addTemporaryAttachment(@QueryParam(value="filename") String filename, @QueryParam(value="projectId") Long projectId, @QueryParam(value="issueId") Long issueId, @QueryParam(value="size") Long size, @QueryParam(value="secureToken") String secureToken, @Context HttpServletRequest request) {
        if (secureToken == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).build();
        }
        User secureUser = this.secureUserTokenManager.useToken(secureToken, SecureUserTokenManager.TokenType.SCREENSHOT);
        if (secureUser == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(CacheControl.never()).build();
        }
        this.authContext.setLoggedInUser(secureUser);
        return this.addTemporaryAttachment(filename, projectId, issueId, size, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"*/*"})
    public Response addTemporaryAttachment(@QueryParam(value="filename") String filename, @QueryParam(value="projectId") Long projectId, @QueryParam(value="issueId") Long issueId, @QueryParam(value="size") Long size, @Context HttpServletRequest request) {
        AttachmentHelper.ValidationResult validationResult = this.attachmentHelper.validate(request, filename, size);
        if (!validationResult.isValid()) {
            switch (validationResult.getErrorType()) {
                case ATTACHMENT_TO_LARGE: {
                    String message = this.authContext.getI18nHelper().getText("upload.too.big", filename, FileSize.format((Long)size), FileSize.format((Long)new Long(Configuration.getString((String)"webwork.multipart.maxSize"))));
                    return AttachTemporaryFileResource.createError(Response.Status.BAD_REQUEST, message);
                }
                case ATTACHMENT_IO_SIZE: {
                    String message = this.authContext.getI18nHelper().getText("attachfile.error.io.size", filename);
                    return AttachTemporaryFileResource.createError(Response.Status.BAD_REQUEST, message);
                }
                case ATTACHMENT_IO_UNKNOWN: {
                    String message = this.authContext.getI18nHelper().getText("attachfile.error.io.error", filename, validationResult.getErrorMessage());
                    return AttachTemporaryFileResource.createError(Response.Status.INTERNAL_SERVER_ERROR, message);
                }
                case FILENAME_BLANK: {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).build();
                }
                case XSRF_TOKEN_INVALID: {
                    return this.createTokenError(this.xsrfGenerator.generateToken(request));
                }
            }
        }
        if (issueId == null && projectId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).build();
        }
        Project project = null;
        Issue issue = null;
        User user = this.authContext.getLoggedInUser();
        if (issueId != null) {
            issue = this.getIssue(user, issueId);
        } else {
            project = this.getProject(user, projectId);
        }
        InputStream inputStream = validationResult.getInputStream();
        try {
            TemporaryAttachment attach = this.webAttachmentManager.createTemporaryAttachment(validationResult.getInputStream(), filename, validationResult.getContentType(), validationResult.getSize(), issue, project);
            Response response = Response.status((Response.Status)Response.Status.CREATED).entity((Object)new GoodResult(attach.getId(), filename)).cacheControl(CacheControl.never()).build();
            return response;
        }
        catch (AttachmentException e) {
            Response response = AttachTemporaryFileResource.createError(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
            return response;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private Issue getIssue(User user, Long id) {
        IssueService.IssueResult result = this.issueService.getIssue(user, id);
        if (result.isValid()) {
            return result.getIssue();
        }
        return (Issue)this.throwFourOhFour(result.getErrorCollection());
    }

    private Project getProject(User user, Long id) {
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectById(user, id);
        if (projectResult.isValid()) {
            return projectResult.getProject();
        }
        return (Project)this.throwFourOhFour(projectResult.getErrorCollection());
    }

    private static Response createError(Response.Status status, ErrorCollection collection) {
        String message = (String)AttachTemporaryFileResource.getFirstElement(collection.getErrorMessages());
        if (message == null) {
            message = (String)AttachTemporaryFileResource.getFirstElement(collection.getErrors().values());
        }
        return AttachTemporaryFileResource.createError(status, message);
    }

    private static Response createError(Response.Status status, String message) {
        return Response.status((Response.Status)status).cacheControl(CacheControl.never()).entity((Object)new BadResult(message)).build();
    }

    private Response createTokenError(String newToken) {
        String message = this.authContext.getI18nHelper().getText("attachfile.xsrf.try.again");
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).cacheControl(CacheControl.never()).entity((Object)new BadResult(message, newToken)).build();
    }

    private <T> T throwFourOhFour(ErrorCollection errorCollection) {
        throw new WebApplicationException(AttachTemporaryFileResource.createError(Response.Status.NOT_FOUND, errorCollection));
    }

    private static <T> T getFirstElement(Collection<? extends T> values) {
        if (!values.isEmpty()) {
            return values.iterator().next();
        }
        return null;
    }

    @XmlRootElement
    public static class BadResult {
        @XmlElement
        private String errorMessage;
        @XmlElement
        private String token;

        private BadResult() {
        }

        BadResult(String msg) {
            this(msg, null);
        }

        BadResult(String msg, String token) {
            this.errorMessage = msg;
            this.token = token;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BadResult badResult = (BadResult)o;
            if (this.errorMessage != null ? !this.errorMessage.equals(badResult.errorMessage) : badResult.errorMessage != null) {
                return false;
            }
            return !(this.token != null ? !this.token.equals(badResult.token) : badResult.token != null);
        }

        public int hashCode() {
            int result = this.errorMessage != null ? this.errorMessage.hashCode() : 0;
            result = 31 * result + (this.token != null ? this.token.hashCode() : 0);
            return result;
        }
    }

    @XmlRootElement
    public static class GoodResult {
        @XmlElement
        private String name;
        @XmlElement
        private String id;

        private GoodResult() {
        }

        GoodResult(long id, String name) {
            this.id = String.valueOf(id);
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GoodResult that = (GoodResult)o;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            return result;
        }
    }
}

