/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.admin;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.AbstractOption;
import com.atlassian.jira.issue.fields.option.IssueConstantOption;
import com.atlassian.jira.issue.fields.option.OptionSet;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.CorsAllowed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

@CorsAllowed
public class IssueTypeSchemeResource {
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final OptionSetManager optionSetManager;
    private final UserProjectHistoryManager projectHistoryManager;
    private final ApplicationProperties applicationProperties;
    private final VelocityRequestContextFactory requestContextFactory;

    public IssueTypeSchemeResource(PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, IssueTypeSchemeManager issueTypeSchemeManager, OptionSetManager optionSetManager, UserProjectHistoryManager projectHistoryManager, ApplicationProperties applicationProperties, VelocityRequestContextFactory requestContextFactory) {
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.optionSetManager = optionSetManager;
        this.projectHistoryManager = projectHistoryManager;
        this.applicationProperties = applicationProperties;
        this.requestContextFactory = requestContextFactory;
    }

    @GET
    @AnonymousAllowed
    public Response getSchemeInfoResponse(@QueryParam(value="includeRecent") @DefaultValue(value="false") boolean includeRecent) {
        return Response.ok((Object)this.getSchemeInfo(includeRecent)).cacheControl(CacheControl.NO_CACHE).build();
    }

    public IssueTypeSchemeInfo getSchemeInfo(boolean includeRecent) {
        ProjectBean projectBean;
        Avatar avatar;
        FieldConfig relevantConfig;
        FieldConfigScheme configScheme;
        User user = this.authenticationContext.getLoggedInUser();
        String currentUser = user == null ? null : user.getName();
        Collection projects = this.permissionManager.getProjectObjects(11, user);
        ArrayList<ProjectBean> projectBeans = new ArrayList<ProjectBean>(projects.size());
        HashSet<FieldConfig> relevantConfigs = new HashSet<FieldConfig>();
        List recentProjects = includeRecent ? this.projectHistoryManager.getProjectHistoryWithPermissionChecks(11, user) : Collections.emptyList();
        ArrayList<ProjectBean> recentProjectBeans = new ArrayList<ProjectBean>(recentProjects.size());
        for (Project project : recentProjects) {
            configScheme = this.issueTypeSchemeManager.getConfigScheme(project);
            relevantConfig = configScheme.getOneAndOnlyConfig();
            avatar = project.getAvatar();
            projectBean = new ProjectBean(project.getId(), project.getName(), project.getKey(), relevantConfig.getId(), avatar == null ? null : avatar.getId());
            recentProjectBeans.add(projectBean);
        }
        for (Project project : projects) {
            configScheme = this.issueTypeSchemeManager.getConfigScheme(project);
            relevantConfig = configScheme.getOneAndOnlyConfig();
            relevantConfigs.add(relevantConfig);
            avatar = project.getAvatar();
            projectBean = new ProjectBean(project.getId(), project.getName(), project.getKey(), relevantConfig.getId(), avatar == null ? null : avatar.getId());
            projectBeans.add(projectBean);
        }
        ArrayList<IssueTypeScheme> schemes = new ArrayList<IssueTypeScheme>(relevantConfigs.size());
        HashSet allOptions = new HashSet();
        for (FieldConfig config : relevantConfigs) {
            OptionSet optionsForConfig = this.optionSetManager.getOptionsForConfig(config);
            allOptions.addAll(optionsForConfig.getOptions());
            IssueType defaultValue = this.issueTypeSchemeManager.getDefaultValue(config);
            String defaultId = defaultValue != null ? defaultValue.getId() : null;
            schemes.add(new IssueTypeScheme(config.getId(), defaultId, optionsForConfig.getOptionIds()));
        }
        ArrayList optionsList = new ArrayList(CollectionUtils.select(allOptions, (Predicate)IssueConstantOption.STANDARD_OPTIONS_PREDICATE));
        Collections.sort(optionsList);
        ArrayList<IssueTypeBean> issueTypeBeans = new ArrayList<IssueTypeBean>(optionsList.size());
        for (AbstractOption option : optionsList) {
            issueTypeBeans.add(new IssueTypeBean(option.getId(), option.getName(), option.getImagePath()));
        }
        String defaultType = this.getSelectedIssueType();
        if (recentProjectBeans.isEmpty()) {
            return new IssueTypeSchemeInfo(schemes, projectBeans, issueTypeBeans, null, defaultType, currentUser);
        }
        if (recentProjectBeans.containsAll(projectBeans)) {
            return new IssueTypeSchemeInfo(schemes, recentProjectBeans, issueTypeBeans, null, defaultType, currentUser);
        }
        return new IssueTypeSchemeInfo(schemes, projectBeans, issueTypeBeans, recentProjectBeans, defaultType, currentUser);
    }

    private String getSelectedIssueType() {
        VelocityRequestContext requestContext = this.requestContextFactory.getJiraVelocityRequestContext();
        VelocityRequestSession session = requestContext.getSession();
        String issuetype = (String)session.getAttribute("jira.user.history.issuetype");
        if (issuetype == null) {
            issuetype = this.applicationProperties.getString("jira.constant.default.issue.type");
        }
        return issuetype;
    }

    @XmlRootElement
    public static class IssueTypeBean {
        @XmlElement
        private String id;
        @XmlElement
        private String name;
        @XmlElement
        private String url;

        private IssueTypeBean() {
        }

        IssueTypeBean(String id, String name, String url) {
            this.id = id;
            this.name = name;
            this.url = url;
        }
    }

    @XmlRootElement
    public static class ProjectBean {
        @XmlElement
        private Long id;
        @XmlElement
        private String name;
        @XmlElement
        private String key;
        @XmlElement
        private Long scheme;
        @XmlElement
        private Long img;

        private ProjectBean() {
        }

        ProjectBean(Long id, String name, String key, Long issueTypeSchemeId, Long avatarId) {
            this.id = id;
            this.name = name;
            this.key = key;
            this.scheme = issueTypeSchemeId;
            this.img = avatarId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectBean that = (ProjectBean)o;
            if (!this.id.equals(that.id)) {
                return false;
            }
            if (!this.img.equals(that.img)) {
                return false;
            }
            if (!this.key.equals(that.key)) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
            return this.scheme.equals(that.scheme);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.key.hashCode();
            result = 31 * result + this.scheme.hashCode();
            result = 31 * result + this.img.hashCode();
            return result;
        }
    }

    @XmlRootElement
    public static class IssueTypeScheme {
        @XmlElement
        private Long id;
        @XmlElement
        private String defaultId;
        @XmlElement
        private Collection<String> types;

        private IssueTypeScheme() {
        }

        IssueTypeScheme(Long schemeId, String defaultId, Collection<String> issueTypes) {
            this.id = schemeId;
            this.defaultId = defaultId;
            this.types = issueTypes;
        }
    }

    @XmlRootElement
    public static class IssueTypeSchemeInfo {
        @XmlElement
        private Collection<IssueTypeScheme> schemes;
        @XmlElement
        private Collection<ProjectBean> projects;
        @XmlElement
        private Collection<ProjectBean> recentProjects;
        @XmlElement
        private Collection<IssueTypeBean> types;
        @XmlElement
        private String defaultType;
        @XmlElement
        private String currentUser;
        @XmlElement
        private boolean isEmpty;

        private IssueTypeSchemeInfo() {
        }

        IssueTypeSchemeInfo(Collection<IssueTypeScheme> schemes, Collection<ProjectBean> projects, Collection<IssueTypeBean> issueTypes, Collection<ProjectBean> recentProjects, String defaultType, String currentUser) {
            this.schemes = schemes;
            this.projects = projects;
            this.types = issueTypes;
            this.recentProjects = recentProjects;
            this.defaultType = defaultType;
            this.isEmpty = projects.isEmpty() || issueTypes.isEmpty() || schemes.isEmpty();
            this.currentUser = currentUser;
        }
    }
}

