/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.admin;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.user.UserAdminHistoryManager;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.CorsAllowed;
import com.atlassian.plugins.rest.common.security.XsrfCheckFailedException;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="adminHistory")
@AnonymousAllowed
@Consumes(value={"application/json", "application/x-www-form-urlencoded"})
@Produces(value={"application/json"})
@CorsAllowed
public class AdminHistoryResource {
    private final UserAdminHistoryManager adminHistoryManager;
    private final JiraAuthenticationContext authenticationContext;
    private final XsrfInvocationChecker xsrfChecker;

    public AdminHistoryResource(UserAdminHistoryManager adminHistoryManager, JiraAuthenticationContext authenticationContext, XsrfInvocationChecker xsrfChecker) {
        this.adminHistoryManager = adminHistoryManager;
        this.authenticationContext = authenticationContext;
        this.xsrfChecker = xsrfChecker;
    }

    @POST
    @Path(value="store")
    public void setHistory(AdminHistoryLink key) {
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(ExecutingHttpRequest.get());
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            throw new XsrfCheckFailedException();
        }
        User user = this.authenticationContext.getLoggedInUser();
        this.adminHistoryManager.addAdminPageToHistory(user, key.id, key.url);
    }

    @XmlRootElement
    public static class AdminHistoryLink {
        @XmlElement
        private String id;
        @XmlElement
        private String url;

        private AdminHistoryLink() {
        }

        AdminHistoryLink(String id, String url) {
            this.id = id;
            this.url = url;
        }
    }
}

