/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.util;

import com.atlassian.jira.rest.exception.BadRequestWebException;
import com.atlassian.jira.rest.exception.ForbiddenWebException;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.exception.ServerErrorWebException;
import com.atlassian.jira.util.ErrorCollection;
import java.util.Collection;
import javax.ws.rs.core.Response;

public class ResponseUtils {
    private ResponseUtils() {
    }

    public static Response throwEx(ErrorCollection errorCollection) {
        ErrorCollection.Reason reason = ErrorCollection.Reason.getWorstReason((Collection)errorCollection.getReasons());
        if (reason == null) {
            reason = ErrorCollection.Reason.SERVER_ERROR;
        }
        com.atlassian.jira.rest.api.util.ErrorCollection errorEntity = com.atlassian.jira.rest.api.util.ErrorCollection.of(errorCollection);
        switch (reason) {
            case NOT_FOUND: {
                throw new NotFoundWebException(errorEntity);
            }
            case NOT_LOGGED_IN: {
                throw new NotAuthorisedWebException(errorEntity);
            }
            case FORBIDDEN: {
                throw new ForbiddenWebException(errorEntity);
            }
            case VALIDATION_FAILED: {
                throw new BadRequestWebException(errorEntity);
            }
        }
        throw new ServerErrorWebException(errorEntity);
    }
}

