/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugin.profile.DarkFeatures;
import com.atlassian.jira.rest.exception.ForbiddenWebException;
import com.atlassian.jira.rest.internal.DarkFeaturePropertyBean;
import com.atlassian.jira.rest.internal.DarkFeaturesBean;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="darkFeatures")
@Produces(value={"application/json"})
public class SiteDarkFeaturesResource {
    private final FeatureManager featureManager;

    public SiteDarkFeaturesResource(FeatureManager featureManager) {
        this.featureManager = (FeatureManager)Assertions.notNull((String)"featureManager", (Object)featureManager);
    }

    @GET
    @Path(value="/{key}")
    public Response get(@PathParam(value="key") String featureKey) {
        if (!this.featureManager.hasSiteEditPermission()) {
            throw new ForbiddenWebException();
        }
        if (StringUtils.isNotBlank((String)featureKey)) {
            boolean enabled = this.featureManager.isEnabled(featureKey);
            return Response.ok((Object)new DarkFeaturePropertyBean(enabled)).cacheControl(CacheControl.NO_CACHE).build();
        }
        return Response.noContent().cacheControl(CacheControl.NO_CACHE).build();
    }

    @PUT
    @Path(value="/{key}")
    @Consumes(value={"application/json"})
    public Response put(@PathParam(value="key") String featureKey, DarkFeaturePropertyBean darkFeaturePropertyBean) {
        if (!this.featureManager.hasSiteEditPermission()) {
            throw new ForbiddenWebException();
        }
        if (StringUtils.isNotBlank((String)featureKey)) {
            this.setSiteDarkFeature(featureKey, darkFeaturePropertyBean.isEnabled());
        }
        return Response.noContent().cacheControl(CacheControl.NO_CACHE).build();
    }

    @PUT
    public DarkFeaturesBean putSiteDarkFeatures(Map<String, DarkFeaturePropertyBean> updates) {
        if (!this.featureManager.hasSiteEditPermission()) {
            throw new ForbiddenWebException();
        }
        for (String feature : updates.keySet()) {
            boolean enabled = updates.get(feature).isEnabled();
            this.setSiteDarkFeature(feature, enabled);
        }
        return this.enabledDarkFeatures();
    }

    private void setSiteDarkFeature(String feature, boolean enabled) {
        if (enabled) {
            this.featureManager.enableSiteDarkFeature(feature.trim());
        } else {
            this.featureManager.disableSiteDarkFeature(feature.trim());
        }
    }

    private DarkFeaturesBean enabledDarkFeatures() {
        DarkFeatures darkFeatures = this.featureManager.getDarkFeatures();
        HashMap result = Maps.newHashMap();
        for (String featureKey : darkFeatures.getAllEnabledFeatures()) {
            result.put(featureKey, new DarkFeaturePropertyBean(true));
        }
        return new DarkFeaturesBean().systemFeatures(darkFeatures.getSystemEnabledFeatures()).siteFeatures(darkFeatures.getSiteEnabledFeatures());
    }
}

