/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal;

import com.atlassian.classloader.TomcatResourceEntriesCacheFlusher;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="cache")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CacheResource {
    private final EventPublisher eventPublisher;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;

    public CacheResource(EventPublisher eventPublisher, JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager) {
        this.eventPublisher = eventPublisher;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
    }

    @Consumes(value={"*/*"})
    @DELETE
    @Path(value="app")
    public Response clearCaches() {
        if (!this.permissionManager.hasPermission(44, this.jiraAuthenticationContext.getUser())) {
            throw new NotAuthorisedWebException();
        }
        this.eventPublisher.publish((Object)ClearCacheEvent.INSTANCE);
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @Consumes(value={"*/*"})
    @DELETE
    @Path(value="classloader")
    public Response clearClassLoaderCache() {
        if (!this.permissionManager.hasPermission(44, this.jiraAuthenticationContext.getUser())) {
            throw new NotAuthorisedWebException();
        }
        new TomcatResourceEntriesCacheFlusher().run();
        return Response.ok().cacheControl(CacheControl.never()).build();
    }
}

