/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.filter;

import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CacheControlResponseFilter
implements ContainerResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(CacheControlResponseFilter.class);

    CacheControlResponseFilter() {
    }

    public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
        MultivaluedMap headers = response.getHttpHeaders();
        if (!headers.containsKey((Object)"Cache-Control") && !headers.containsKey((Object)"Expires")) {
            log.trace("Response does not have caching headers, adding 'Cache-Control: no-cache, no-store'");
            headers.putSingle((Object)"Cache-Control", (Object)"no-cache, no-store, no-transform");
        }
        return response;
    }
}

