/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.domain.input;

import com.google.common.base.Objects;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class VersionInput {
    private final String projectKey;
    private final String name;
    @Nullable
    private final String description;
    private final DateTime releaseDate;
    private boolean isArchived;
    private boolean isReleased;

    public VersionInput(String projectKey, String name, @Nullable String description, @Nullable DateTime releaseDate, boolean isArchived, boolean isReleased) {
        this.projectKey = projectKey;
        this.name = name;
        this.description = description;
        this.releaseDate = releaseDate;
        this.isArchived = isArchived;
        this.isReleased = isReleased;
    }

    public static VersionInput create(String projectKey, String name, @Nullable String description, @Nullable DateTime releaseDate, boolean archived, boolean release) {
        return new VersionInput(projectKey, name, description, releaseDate, archived, release);
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public DateTime getReleaseDate() {
        return this.releaseDate;
    }

    public boolean isArchived() {
        return this.isArchived;
    }

    public boolean isReleased() {
        return this.isReleased;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("projectKey", (Object)this.projectKey).add("description", (Object)this.description).add("releaseDate", (Object)this.releaseDate).add("isArchived", (Object)this.isArchived).add("isReleased", (Object)this.isReleased).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof VersionInput) {
            VersionInput that = (VersionInput)obj;
            return Objects.equal((Object)this.projectKey, (Object)that.projectKey) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.releaseDate, (Object)that.releaseDate) && Objects.equal((Object)this.isArchived, (Object)that.isArchived) && Objects.equal((Object)this.isReleased, (Object)that.isReleased);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.projectKey, this.description, this.releaseDate, this.isArchived, this.isReleased});
    }
}

