/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.domain.BasicUser;
import com.atlassian.jira.rest.client.domain.Visibility;
import com.atlassian.jira.rest.client.domain.Worklog;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import com.atlassian.jira.rest.client.internal.json.VisibilityJsonParser;
import java.net.URI;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;

public class WorklogJsonParserV5
implements JsonParser<Worklog> {
    private final URI issue;

    public WorklogJsonParserV5(URI issue) {
        this.issue = issue;
    }

    @Override
    public Worklog parse(JSONObject json) throws JSONException {
        URI self = JsonParseUtil.getSelfUri(json);
        BasicUser author = JsonParseUtil.parseBasicUser(json.getJSONObject("author"));
        BasicUser updateAuthor = JsonParseUtil.parseBasicUser(json.getJSONObject("updateAuthor"));
        String comment = json.getString("comment");
        DateTime creationDate = JsonParseUtil.parseDateTime(json, "created");
        DateTime updateDate = JsonParseUtil.parseDateTime(json, "updated");
        DateTime startDate = JsonParseUtil.parseDateTime(json, "started");
        int secondsSpent = json.getInt("timeSpentSeconds");
        Visibility visibility = new VisibilityJsonParser().parseVisibility(json);
        return new Worklog(self, this.issue, author, updateAuthor, comment, creationDate, updateDate, startDate, secondsSpent / 60, visibility);
    }
}

