/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.domain.BasicUser;
import com.atlassian.jira.rest.client.domain.Visibility;
import com.atlassian.jira.rest.client.domain.Worklog;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import com.atlassian.jira.rest.client.internal.json.VisibilityJsonParser;
import java.net.URI;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;

public class WorklogJsonParser
implements JsonParser<Worklog> {
    @Override
    public Worklog parse(JSONObject json) throws JSONException {
        URI self = JsonParseUtil.getSelfUri(json);
        URI issueUri = JsonParseUtil.parseURI(json.getString("issue"));
        BasicUser author = JsonParseUtil.parseBasicUser(json.getJSONObject("author"));
        BasicUser updateAuthor = JsonParseUtil.parseBasicUser(json.getJSONObject("updateAuthor"));
        String comment = json.getString("comment");
        DateTime creationDate = JsonParseUtil.parseDateTime(json, "created");
        DateTime updateDate = JsonParseUtil.parseDateTime(json, "updated");
        DateTime startDate = JsonParseUtil.parseDateTime(json, "started");
        int minutesSpent = json.getInt("minutesSpent");
        Visibility visibility = new VisibilityJsonParser().parseVisibility(json);
        return new Worklog(self, issueUri, author, updateAuthor, comment, creationDate, updateDate, startDate, minutesSpent, visibility);
    }
}

