/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json.gen;

import com.atlassian.jira.rest.client.domain.Comment;
import com.atlassian.jira.rest.client.domain.ServerInfo;
import com.atlassian.jira.rest.client.domain.Visibility;
import com.atlassian.jira.rest.client.internal.json.gen.JsonGenerator;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class CommentJsonGenerator
implements JsonGenerator<Comment> {
    private final ServerInfo serverInfo;
    private final String groupLevelAttribute;

    public CommentJsonGenerator(ServerInfo serverInfo) {
        this(serverInfo, "groupLevel");
    }

    public CommentJsonGenerator(ServerInfo serverInfo, String groupLevelAttribute) {
        this.serverInfo = serverInfo;
        this.groupLevelAttribute = groupLevelAttribute;
    }

    @Override
    public JSONObject generate(Comment comment) throws JSONException {
        Visibility commentVisibility;
        JSONObject res = new JSONObject();
        if (comment.getBody() != null) {
            res.put("body", (Object)comment.getBody());
        }
        if ((commentVisibility = comment.getVisibility()) != null) {
            if (this.serverInfo.getBuildNumber() >= 600) {
                JSONObject visibilityJson = new JSONObject();
                visibilityJson.put("type", (Object)(commentVisibility.getType() == Visibility.Type.GROUP ? "GROUP" : "ROLE"));
                visibilityJson.put("value", (Object)commentVisibility.getValue());
                res.put("visibility", (Object)visibilityJson);
            } else if (commentVisibility.getType() == Visibility.Type.ROLE) {
                res.put("role", (Object)commentVisibility.getValue());
            } else {
                res.put(this.getGroupLevelAttribute(), (Object)commentVisibility.getValue());
            }
        }
        return res;
    }

    protected String getGroupLevelAttribute() {
        return this.groupLevelAttribute;
    }
}

